/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientDeployableScalableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        try (OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);){
            ProjectRequest projectRequest = ((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName("thisisatest")).addToLabels("project", "thisisatest")).endMetadata()).build();
            DeploymentConfigExamples.log("Created project", client.projectrequests().create((Object[])new ProjectRequest[]{projectRequest}));
            ServiceAccount fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build();
            ((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace("thisisatest")).createOrReplace((Object)fabric8);
            DeploymentConfigExamples.log("Created deployment", ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)((DeploymentConfigFluent.MetadataNested)((DoneableDeploymentConfig)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).createOrReplaceWithNew()).withNewMetadata().withName("nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).addNewTrigger().withType("ConfigChange")).endTrigger()).addToSelector("app", "nginx")).withNewTemplate().withNewMetadata().addToLabels("app", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done());
            ((ClientDeployableScalableResource)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).withName("nginx")).scale(2, true);
            DeploymentConfigExamples.log("Created pods:", ((PodList)((ClientNonNamespaceOperation)client.pods().inNamespace("thisisatest")).list()).getItems());
            ((ClientDeployableScalableResource)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).withName("nginx")).delete();
            DeploymentConfigExamples.log("Pods:", ((PodList)((ClientNonNamespaceOperation)client.pods().inNamespace("thisisatest")).list()).getItems());
            DeploymentConfigExamples.log("Replication Controllers:", ((ReplicationControllerList)((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).list()).getItems());
            DeploymentConfigExamples.log("Done.");
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

