/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient client = new DefaultKubernetesClient(config);
        try {
            Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).addToLabels("this", "rocks")).endMetadata()).build();
            DeploymentExamples.log("Created namespace", client.namespaces().createOrReplace((Object[])new Namespace[]{ns}));
            ServiceAccount fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build();
            ((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace("thisisatest")).createOrReplace((Object[])new ServiceAccount[]{fabric8});
            for (int i = 0; i < 2; ++i) {
                System.err.println("Iteration:" + (i + 1));
                Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build();
                deployment = (Deployment)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("thisisatest")).create((Object[])new Deployment[]{deployment});
                DeploymentExamples.log("Created deployment", deployment);
                System.err.println("Scaling up:" + deployment.getMetadata().getName());
                ((ClientScaleableResource)((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace("thisisatest")).withName("nginx")).scale(2, true);
                DeploymentExamples.log("Created replica sets:", ((ReplicaSetList)((ClientNonNamespaceOperation)client.extensions().replicaSets().inNamespace("thisisatest")).list()).getItems());
                System.err.println("Deleting:" + deployment.getMetadata().getName());
                client.resource((HasMetadata)deployment).delete();
            }
            DeploymentExamples.log("Done.");
        }
        finally {
            ((ClientResource)client.namespaces().withName("thisisatest")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

