/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePod {
    private static final Logger logger = LoggerFactory.getLogger(CreatePod.class);

    public static void main(String[] args) {
        File file;
        if (args.length == 0) {
            System.out.println("Usage: podJsonFileName <token> <namespace>");
            return;
        }
        String fileName = args[0];
        String namespace = null;
        if (args.length > 2) {
            namespace = args[2];
        }
        if (!(file = new File(fileName)).exists() || !file.isFile()) {
            System.err.println("File does not exist: " + fileName);
            return;
        }
        ConfigBuilder builder = new ConfigBuilder();
        if (args.length > 1) {
            builder.withOauthToken(args[1]);
        }
        Config config = builder.build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            List resources;
            if (namespace == null) {
                namespace = client.getNamespace();
            }
            if ((resources = (List)client.load((InputStream)new FileInputStream(fileName)).get()).isEmpty()) {
                System.err.println("No resources loaded from file: " + fileName);
                return;
            }
            HasMetadata resource = (HasMetadata)resources.get(0);
            if (resource instanceof Pod) {
                Pod pod = (Pod)resource;
                System.out.println("Creating pod in namespace " + namespace);
                NonNamespaceOperation pods = (NonNamespaceOperation)client.pods().inNamespace(namespace);
                Pod result = (Pod)pods.create((Object)pod);
                System.out.println("Created pod " + result.getMetadata().getName());
            } else {
                System.err.println("Loaded resource is not a Pod! " + resource);
            }
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

