/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointsExample {
    private static final Logger logger = LoggerFactory.getLogger(EndpointsExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String master = "https://localhost:8443";
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            try {
                String namespace = "default";
                EndpointsExample.log("namespace", namespace);
                Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).load(EndpointsExample.class.getResourceAsStream("/endpoints-deployment.yml"))).get();
                EndpointsExample.log("Deployment created");
                ((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).create((Object[])new Deployment[]{deployment});
                Service service = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).load(EndpointsExample.class.getResourceAsStream("/endpoints-service.yml"))).get();
                EndpointsExample.log("Service created");
                ((NonNamespaceOperation)client.services().inNamespace(namespace)).create((Object[])new Service[]{service});
                Endpoints endpoints = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsBuilder)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("external-web")).withNamespace(namespace)).endMetadata()).withSubsets(new EndpointSubset[0])).addNewSubset().addNewAddress().withIp("10.10.50.53")).endAddress()).addNewPort().withPort(Integer.valueOf(80))).withName("apache")).endPort()).endSubset()).build();
                EndpointsExample.log("Endpoint created");
                ((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).create((Object[])new Endpoints[]{endpoints});
                EndpointsExample.log("Endpoint url");
                endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName("external-web")).get();
                EndpointsExample.log("Endpoint Port", ((EndpointPort)((EndpointSubset)endpoints.getSubsets().get(0)).getPorts().get(0)).getName());
            }
            finally {
                ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace("default")).withName("endpoints-deployment")).delete();
                ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace("default")).withName("endpoints-nginx")).delete();
                ((Resource)((NonNamespaceOperation)client.endpoints().inNamespace("default")).withName("external-web")).delete();
            }
        }
        catch (Exception e) {
            EndpointsExample.log("Exception occurred: ", e.getMessage());
            e.printStackTrace();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

