/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkPolicyExample {
    private static final Logger logger = LoggerFactory.getLogger(NetworkPolicyExample.class);

    public static void main(String[] args) {
        String namespace = "default";
        if (args.length > 0) {
            namespace = args[0];
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            NetworkPolicy networkPolicy = ((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyBuilder)((NetworkPolicyFluent.MetadataNested)new NetworkPolicyBuilder().withNewMetadata().withName("test-network-policy")).endMetadata()).withNewSpec().withNewPodSelector().withMatchLabels(Collections.singletonMap("role", "db"))).endPodSelector()).endSpec()).build();
            networkPolicy = (NetworkPolicy)((NonNamespaceOperation)client.network().v1().networkPolicies().inNamespace(namespace)).createOrReplace((Object[])new NetworkPolicy[]{networkPolicy});
            logger.info("NetworkPolicy {}/{} created via builders", (Object)namespace, (Object)networkPolicy.getMetadata().getName());
            networkPolicy = (NetworkPolicy)((Resource)((NonNamespaceOperation)client.network().v1().networkPolicies().inNamespace(namespace)).load(NetworkPolicyExample.class.getResourceAsStream("/network-policy.yml"))).createOrReplace((Object[])new NetworkPolicy[0]);
            logger.info("NetworkPolicy {}/{} created via YAML manifest", (Object)namespace, (Object)networkPolicy.getMetadata().getName());
        }
    }
}

