/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.List;
import java.util.Objects;

public class DeploymentConfigScale {
    public static void main(String[] args) {
        int replicas;
        if (args.length < 2) {
            System.err.println("Usage nameOfDC replicas");
            return;
        }
        String name = args[0];
        String replicaText = args[1];
        try {
            replicas = Integer.parseInt(replicaText);
        }
        catch (NumberFormatException e) {
            System.out.println("Could not parse integer " + replicaText + " due to: " + e);
            return;
        }
        try {
            Integer oldReplicas = 0;
            DefaultOpenShiftClient client = new DefaultOpenShiftClient();
            if (!client.supportsOpenShiftAPIGroup("apps.openshift.io")) {
                System.out.println("WARNING this cluster does not support the API Group apps.openshift.io");
                return;
            }
            DeployableScalableResource resource = (DeployableScalableResource)client.deploymentConfigs().withName(name);
            DeploymentConfig deploymentConfig = (DeploymentConfig)resource.get();
            if (deploymentConfig == null) {
                System.out.println("Could not find a DeploymentConfig for name: " + name);
                return;
            }
            try {
                DeploymentConfigSpec spec = deploymentConfig.getSpec();
                oldReplicas = spec.getReplicas();
                spec.setReplicas(Integer.valueOf(replicas));
                DeploymentConfig updated = (DeploymentConfig)resource.patch((Object)deploymentConfig);
                System.out.println("Updated the DeploymentConfig " + name + " version: " + deploymentConfig.getApiVersion() + " with replicas: " + replicas + " to resourceVersion: " + updated.getMetadata().getResourceVersion());
            }
            catch (Exception e) {
                System.out.println("Failed to update the DeploymentConfig " + name + " with replicas: " + replicas);
                e.printStackTrace();
            }
            DeploymentConfigList list = Objects.requireNonNull((DeploymentConfigList)client.deploymentConfigs().list(), "No DeploymentConfigList returned");
            List items = Objects.requireNonNull(list.getItems(), "No DeploymentConfigList.getItems() returned");
            DeploymentConfig found = null;
            for (DeploymentConfig item : items) {
                if (!name.equals(item.getMetadata().getName())) continue;
                found = item;
                break;
            }
            Objects.requireNonNull(found, "Could not find DeploymentConfig in list.getItems() for name: " + name);
            found.getSpec().setReplicas(oldReplicas);
            try {
                DeploymentConfig updated = (DeploymentConfig)resource.patch((Object)found);
                System.out.println("Updated the list.item DeploymentConfig " + name + " version: " + found.getApiVersion() + " with replicas: " + oldReplicas + " to resourceVersion: " + updated.getMetadata().getResourceVersion());
            }
            catch (Exception e) {
                System.out.println("Failed to update the list.item DeploymentConfig " + name + " with replicas: " + oldReplicas);
                e.printStackTrace();
            }
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

