/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDeploymentConfigs {
    private static final Logger logger = LoggerFactory.getLogger(ListDeploymentConfigs.class);

    public static void main(String[] args) {
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient();){
            if (!client.supportsOpenShiftAPIGroup("apps.openshift.io")) {
                logger.warn("This cluster does not support the API Group {}", (Object)"apps.openshift.io");
                return;
            }
            DeploymentConfigList list = (DeploymentConfigList)client.deploymentConfigs().list();
            if (list == null) {
                logger.error("No list returned!");
                return;
            }
            List items = list.getItems();
            for (DeploymentConfig item : items) {
                logger.info("DeploymentConfig {} has version: {}", (Object)item.getMetadata().getName(), (Object)item.getApiVersion());
            }
            if (!items.isEmpty()) {
                DeploymentConfig deploymentConfig = (DeploymentConfig)items.get(0);
                String name = deploymentConfig.getMetadata().getName();
                deploymentConfig = (DeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(name)).get();
                if (deploymentConfig == null) {
                    logger.error("No DeploymentConfig found for name {}", (Object)name);
                    return;
                }
                logger.info("get() DeploymentConfig {} has version: {}", (Object)name, (Object)deploymentConfig.getApiVersion());
            }
        }
        catch (KubernetesClientException e) {
            logger.error("Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

