/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeleteExamples.class);
    private static final String NAMESPACE = "this-is-a-test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            try {
                logger.info("Create namespace: {}", client.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(NAMESPACE)).endMetadata()).build()));
                logger.info("Deleted namespace: {}", (Object)((Resource)client.namespaces().withName(NAMESPACE)).delete());
                logger.info("Deleted testPod: {}", (Object)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).withName("test-pod")).delete());
                logger.info("Deleted pod by label: {}", (Object)((FilterWatchListDeletable)client.pods().withLabel("this", "works")).delete());
            }
            catch (KubernetesClientException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ((Resource)client.namespaces().withName(NAMESPACE)).delete();
            }
        }
    }
}

