/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ExecuteCommandOnPodExample
implements AutoCloseable {
    private final KubernetesClient client;

    public ExecuteCommandOnPodExample() {
        Config config = new ConfigBuilder().build();
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    @Override
    public void close() {
        this.client.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execCommandOnPod(String podName, String namespace, String ... cmd) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podName)).get();
        System.out.printf("Running command: [%s] on pod [%s] in namespace [%s]%n", Arrays.toString(cmd), pod.getMetadata().getName(), namespace);
        CompletableFuture<String> data = new CompletableFuture<String>();
        try (ExecWatch execWatch = this.execCmd(pod, data, cmd);){
            String string = data.get(10L, TimeUnit.SECONDS);
            return string;
        }
    }

    private ExecWatch execCmd(Pod pod, CompletableFuture<String> data, String ... command) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).writingOutput((OutputStream)baos).writingError((OutputStream)baos).usingListener((ExecListener)new SimpleListener(data, baos)).exec(command);
    }

    public static void main(String[] args) {
        String pod = "";
        String namespace = "default";
        String command = "df -h";
        try (ExecuteCommandOnPodExample example = new ExecuteCommandOnPodExample();){
            String cmdOutput = example.execCommandOnPod("", "default", "df -h".split(" "));
            System.out.println(cmdOutput);
        }
    }

    static class SimpleListener
    implements ExecListener {
        private CompletableFuture<String> data;
        private ByteArrayOutputStream baos;

        public SimpleListener(CompletableFuture<String> data, ByteArrayOutputStream baos) {
            this.data = data;
            this.baos = baos;
        }

        public void onOpen() {
            System.out.println("Reading data... ");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            System.err.println(t.getMessage());
            this.data.completeExceptionally(t);
        }

        public void onClose(int code, String reason) {
            System.out.println("Exit with: " + code + " and with reason: " + reason);
            this.data.complete(this.baos.toString());
        }
    }
}

