/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.examples.crds.Dummy;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceInformerExample {
    private static final Logger logger = LoggerFactory.getLogger(CustomResourceInformerExample.class);

    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            SharedInformerFactory sharedInformerFactory = client.informers();
            SharedIndexInformer podInformer = sharedInformerFactory.sharedIndexInformerFor(Dummy.class, 60000L);
            logger.info("Informer factory initialized.");
            podInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<Dummy>(){

                public void onAdd(Dummy pod) {
                    logger.info("{} dummy added", (Object)pod.getMetadata().getName());
                }

                public void onUpdate(Dummy oldPod, Dummy newPod) {
                    logger.info("{} dummy updated", (Object)oldPod.getMetadata().getName());
                }

                public void onDelete(Dummy pod, boolean deletedFinalStateUnknown) {
                    logger.info("{} dummy deleted", (Object)pod.getMetadata().getName());
                }
            });
            podInformer.stopped().whenComplete((v, t) -> {
                if (t != null) {
                    logger.error("Exception occurred, caught: {}", (Object)t.getMessage());
                }
            });
            logger.info("Starting all registered informers");
            sharedInformerFactory.startAllRegisteredInformers();
            Executors.newSingleThreadExecutor().submit(() -> {
                Thread.currentThread().setName("HAS_SYNCED_THREAD");
                try {
                    while (true) {
                        logger.info("podInformer.hasSynced() : {}", (Object)podInformer.hasSynced());
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException inEx) {
                    Thread.currentThread().interrupt();
                    logger.warn("HAS_SYNCED_THREAD interrupted: {}", (Object)inEx.getMessage());
                    return;
                }
            });
            Dummy toCreate = new Dummy();
            toCreate.getMetadata().setName("dummy");
            if (client.getConfiguration().getNamespace() != null) {
                toCreate.getMetadata().setNamespace(client.getConfiguration().getNamespace());
            } else if (client.getNamespace() != null) {
                toCreate.getMetadata().setNamespace(client.getNamespace());
            } else {
                toCreate.getMetadata().setNamespace(((NamespaceList)client.namespaces().list()).getItems().stream().findFirst().map(HasMetadata::getMetadata).map(ObjectMeta::getNamespace).orElse("default"));
            }
            client.resources(Dummy.class).createOrReplace((Object)toCreate);
            TimeUnit.MINUTES.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.warn("interrupted: {}", (Object)interruptedException.getMessage());
        }
    }
}

