/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.WebHookTriggerBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigExamples {
    private static final Logger logger = LoggerFactory.getLogger(BuildConfigExamples.class);
    private static final String NAMESPACE = "this-is-a-test";

    public static void main(String[] args) throws InterruptedException {
        try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();){
            String namespace;
            OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
            if (client.getNamespace() != null) {
                namespace = client.getNamespace();
                logger.info("Using configured namespace: {}", (Object)namespace);
            } else {
                Namespace ns = (Namespace)((Resource)client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(NAMESPACE)).addToLabels("this", "rocks")).endMetadata()).build())).create();
                namespace = ns.getMetadata().getName();
                logger.info("Created namespace: {}", (Object)namespace);
            }
            ((ServiceAccountResource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(namespace)).resource((Object)((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build())).create();
            ImageStream is = (ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).resource((Object)((ImageStreamBuilder)((ImageStreamFluent.StatusNested)((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName("example-camel-cdi")).endMetadata()).withNewSpec().addNewTag().withName("latest")).endTag()).withDockerImageRepository("fabric8/example-camel-cdi")).endSpec()).withNewStatus().withDockerImageRepository("")).endStatus()).build())).create();
            logger.info("Created image stream: {}", (Object)is.getMetadata().getName());
            String buildConfigName = "custom-build-config";
            BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).resource((Object)((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.ResourcesNested)((BuildConfigSpecFluent.ResourcesNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName("custom-build-config")).endMetadata()).withNewSpec().withServiceAccount("fabric8")).withNewSource().withType("Git")).withNewGit().withUri("https://github.com/fabric8io/example-camel-cdi.git")).endGit()).endSource()).withNewResources().addToLimits("mykey", new Quantity("10"))).addToRequests("mykey", new Quantity("10"))).endResources()).withNewStrategy().withType("Source")).withNewSourceStrategy().withNewFrom().withName("java-sti:latest")).withKind("DockerImage")).endFrom()).endSourceStrategy()).endStrategy()).withNewOutput().withNewTo().withKind("DockerImage")).withName("example-camel-cdi:latest")).endTo()).endOutput()).addNewTrigger().withType("GitHub")).withNewGithub().withSecret("secret101")).endGithub()).endTrigger()).endSpec()).build())).create();
            logger.info("Created Build Config: {}", (Object)buildConfig.getMetadata().getName());
            Build build = (Build)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).withName("custom-build-config")).instantiate(((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName("custom-build-config")).endMetadata()).build());
            logger.info("Instantiated Build: {}", (Object)build.getMetadata().getName());
            ((Triggerable)((Typeable)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).withName("custom-build-config")).withSecret("secret101")).withType("github")).trigger((Object)((WebHookTriggerBuilder)new WebHookTriggerBuilder().withSecret("secret101")).build());
            logger.info("Triggered Build Config: {}", (Object)"custom-build-config");
            Thread.sleep(6000L);
            logger.info("Builds:");
            for (Build b : ((BuildList)((NonNamespaceOperation)client.builds().inNamespace(namespace)).list()).getItems()) {
                logger.info("\t\t\t{}", (Object)b.getMetadata().getName());
                logger.info("\t\t\t\t\t Log:");
                ((BuildResource)((NonNamespaceOperation)client.builds().inNamespace(namespace)).withName(b.getMetadata().getName())).watchLog((OutputStream)System.out);
            }
            logger.info("Done");
        }
    }
}

