/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.jdkhttp.JdkWebSocketImpl;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.net.http.WebSocketHandshakeException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;

public class JdkHttpClientImpl
extends StandardHttpClient<JdkHttpClientImpl, JdkHttpClientFactory, JdkHttpClientBuilderImpl> {
    private java.net.http.HttpClient httpClient;

    public JdkHttpClientImpl(JdkHttpClientBuilderImpl builder, java.net.http.HttpClient httpClient) {
        super((StandardHttpClientBuilder)builder);
        this.httpClient = httpClient;
    }

    public void close() {
        if (this.httpClient == null) {
            return;
        }
        ((JdkHttpClientFactory)this.builder.getClientFactory()).closeHttpClient(this);
        this.httpClient = null;
    }

    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy((HttpClient)this);
    }

    public CompletableFuture<io.fabric8.kubernetes.client.http.HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        AsyncBodySubscriber<List<ByteBuffer>> subscriber = new AsyncBodySubscriber<List<ByteBuffer>>(consumer);
        HttpResponse.BodyHandler<Void> handler = HttpResponse.BodyHandlers.fromSubscriber(subscriber);
        BodyHandlerAdapter handlerAdapter = new BodyHandlerAdapter(subscriber, handler);
        return this.getHttpClient().sendAsync(this.requestBuilder(request).build(), handlerAdapter).thenApply(r -> new JdkHttpResponseImpl<AsyncBody>((HttpResponse<?>)r, (AsyncBody)r.body()));
    }

    HttpRequest.Builder requestBuilder(StandardHttpRequest request) {
        StandardHttpRequest.BodyContent body;
        HttpRequest.Builder requestBuilder = java.net.http.HttpRequest.newBuilder();
        Duration timeout = request.getTimeout();
        if (timeout != null && !Duration.ZERO.equals(timeout)) {
            requestBuilder.timeout(timeout);
        }
        request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> requestBuilder.header((String)e.getKey(), (String)v)));
        if (request.getContentType() != null) {
            requestBuilder.setHeader("Content-Type", request.getContentType());
        }
        if ((body = request.body()) != null) {
            if (body instanceof StandardHttpRequest.StringBodyContent) {
                requestBuilder.method(request.method(), HttpRequest.BodyPublishers.ofString(((StandardHttpRequest.StringBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                requestBuilder.method(request.method(), HttpRequest.BodyPublishers.ofByteArray(((StandardHttpRequest.ByteArrayBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.InputStreamBodyContent) {
                final StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)body;
                final HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofInputStream(() -> ((StandardHttpRequest.InputStreamBodyContent)bodyContent).getContent());
                requestBuilder.method(request.method(), new HttpRequest.BodyPublisher(){

                    @Override
                    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                        publisher.subscribe(subscriber);
                    }

                    @Override
                    public long contentLength() {
                        return bodyContent.getLength();
                    }
                });
            } else {
                throw new AssertionError((Object)"Unsupported body content");
            }
        }
        requestBuilder.uri(request.uri());
        if (request.isExpectContinue() && ((JdkHttpClientFactory)this.builder.getClientFactory()).useExpectContinue()) {
            requestBuilder.expectContinue(true);
        }
        return requestBuilder;
    }

    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        Duration timeout;
        StandardHttpRequest request = standardWebSocketBuilder.asHttpRequest();
        WebSocket.Builder newBuilder = this.getHttpClient().newWebSocketBuilder();
        request.headers().forEach((k, v) -> v.forEach(s -> newBuilder.header((String)k, (String)s)));
        if (standardWebSocketBuilder.getSubprotocol() != null) {
            newBuilder.subprotocols(standardWebSocketBuilder.getSubprotocol(), new String[0]);
        }
        if ((timeout = request.getTimeout()) != null && !Duration.ZERO.equals(timeout)) {
            newBuilder.connectTimeout(timeout);
        }
        CompletableFuture<WebSocketResponse> response = new CompletableFuture<WebSocketResponse>();
        URI uri = WebSocket.toWebSocketUri((URI)request.uri());
        JdkWebSocketImpl fabric8WebSocket = new JdkWebSocketImpl(listener);
        newBuilder.buildAsync(uri, fabric8WebSocket).whenComplete((jdkWebSocket, t) -> {
            if (t instanceof CompletionException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof WebSocketHandshakeException) {
                HttpResponse<?> jdkResponse = ((WebSocketHandshakeException)t).getResponse();
                WebSocketUpgradeResponse upgradeResponse = new WebSocketUpgradeResponse((HttpRequest)request, jdkResponse.statusCode(), jdkResponse.headers().map());
                response.complete(new WebSocketResponse(upgradeResponse, t));
            } else if (t != null) {
                response.completeExceptionally((Throwable)t);
            } else {
                response.complete(new WebSocketResponse(new WebSocketUpgradeResponse((HttpRequest)request), (WebSocket)fabric8WebSocket));
            }
        });
        return response;
    }

    java.net.http.HttpClient getHttpClient() {
        if (this.httpClient == null) {
            throw new IllegalStateException("Client already closed");
        }
        return this.httpClient;
    }

    private static class JdkHttpResponseImpl<T>
    implements io.fabric8.kubernetes.client.http.HttpResponse<T> {
        private HttpResponse<?> response;
        private T body;

        public JdkHttpResponseImpl(HttpResponse<T> response) {
            this(response, response.body());
        }

        public JdkHttpResponseImpl(HttpResponse<?> response, T body) {
            this.response = response;
            this.body = body;
        }

        public List<String> headers(String key) {
            return this.response.headers().allValues(key);
        }

        public Map<String, List<String>> headers() {
            return this.response.headers().map();
        }

        public int code() {
            return this.response.statusCode();
        }

        public T body() {
            return this.body;
        }

        public HttpRequest request() {
            java.net.http.HttpRequest request = this.response.request();
            return new StandardHttpRequest(request.headers().map(), request.uri(), request.method(), null);
        }

        public Optional<io.fabric8.kubernetes.client.http.HttpResponse<?>> previousResponse() {
            return this.response.previousResponse().map(JdkHttpResponseImpl::new);
        }
    }

    private static final class AsyncBodySubscriber<T>
    implements Flow.Subscriber<T>,
    AsyncBody {
        private final AsyncBody.Consumer<T> consumer;
        private final CompletableFuture<Void> done = new CompletableFuture();
        private final CompletableFuture<Flow.Subscription> subscription = new CompletableFuture();

        private AsyncBodySubscriber(AsyncBody.Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription.isDone()) {
                subscription.cancel();
                return;
            }
            this.subscription.complete(subscription);
        }

        @Override
        public void onNext(T item) {
            try {
                if (item == null) {
                    this.done.complete(null);
                } else {
                    this.consumer.consume(item, (AsyncBody)this);
                }
            }
            catch (Exception e) {
                this.subscription.thenAccept(Flow.Subscription::cancel);
                this.done.completeExceptionally(e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.done.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            this.done.complete(null);
        }

        public void consume() {
            if (this.done.isDone()) {
                return;
            }
            this.subscription.thenAccept(s -> s.request(1L));
        }

        public CompletableFuture<Void> done() {
            return this.done;
        }

        public void cancel() {
            this.subscription.thenAccept(Flow.Subscription::cancel);
            this.done.cancel(false);
        }
    }

    private static final class BodyHandlerAdapter
    implements HttpResponse.BodyHandler<AsyncBody> {
        private final AsyncBodySubscriber<?> subscriber;
        private final HttpResponse.BodyHandler<Void> handler;

        private BodyHandlerAdapter(AsyncBodySubscriber<?> subscriber, HttpResponse.BodyHandler<Void> handler) {
            this.subscriber = subscriber;
            this.handler = handler;
        }

        @Override
        public HttpResponse.BodySubscriber<AsyncBody> apply(HttpResponse.ResponseInfo responseInfo) {
            final HttpResponse.BodySubscriber<Void> bodySubscriber = this.handler.apply(responseInfo);
            return new HttpResponse.BodySubscriber<AsyncBody>(){
                CompletableFuture<AsyncBody> cf;
                {
                    this.cf = CompletableFuture.completedFuture(subscriber);
                }

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    bodySubscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    bodySubscriber.onNext(item.stream().map(BufferUtil::copy).collect(Collectors.toList()));
                }

                @Override
                public void onError(Throwable throwable) {
                    bodySubscriber.onError(throwable);
                }

                @Override
                public void onComplete() {
                    bodySubscriber.onComplete();
                }

                @Override
                public CompletionStage<AsyncBody> getBody() {
                    return this.cf;
                }
            };
        }
    }
}

