/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.client.api.Response;

public class JettyHttpResponse<T>
implements HttpResponse<T> {
    private final HttpRequest request;
    private final Response response;
    private final T body;

    public JettyHttpResponse(HttpRequest request, Response response, T body) {
        this.request = request;
        this.response = response;
        this.body = body;
    }

    public List<String> headers(String key) {
        return this.response.getHeaders().getValuesList(key);
    }

    public Map<String, List<String>> headers() {
        return this.response.getHeaders().stream().reduce(new HashMap(), (m, e) -> {
            m.compute(e.getName(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<String>();
                }
                v.add(e.getValue());
                return v;
            });
            return m;
        }, (m1, m2) -> m1);
    }

    public int code() {
        return this.response.getStatus();
    }

    public T body() {
        return this.body;
    }

    public HttpRequest request() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Optional<HttpResponse<?>> previousResponse() {
        return Optional.empty();
    }
}

