/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpWebSocketImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientImpl
extends StandardHttpClient<OkHttpClientImpl, OkHttpClientFactory, OkHttpClientBuilderImpl> {
    static final transient Logger LOG = LoggerFactory.getLogger(OkHttpClientImpl.class);
    static final Map<String, MediaType> MEDIA_TYPES = new ConcurrentHashMap<String, MediaType>();
    public static final MediaType JSON = OkHttpClientImpl.parseMediaType("application/json");
    private final OkHttpClient httpClient;

    static MediaType parseMediaType(String contentType) {
        MediaType result = MediaType.parse((String)contentType);
        MEDIA_TYPES.put(contentType, result);
        return result;
    }

    public OkHttpClientImpl(OkHttpClient client, OkHttpClientBuilderImpl builder) {
        super((StandardHttpClientBuilder)builder);
        this.httpClient = client;
    }

    public void close() {
        ExecutorService executorService;
        LOG.debug("Shutting down dispatcher " + this.httpClient.dispatcher(), (Throwable)new Exception());
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    private CompletableFuture<HttpResponse<AsyncBody>> sendAsync(HttpRequest request, final Function<BufferedSource, AsyncBody> handler) {
        final CompletableFuture<HttpResponse<AsyncBody>> future = new CompletableFuture<HttpResponse<AsyncBody>>();
        Call call = this.httpClient.newCall(this.requestBuilder((StandardHttpRequest)request).build());
        try {
            call.enqueue(new Callback(){

                public void onResponse(Call call, Response response) throws IOException {
                    BufferedSource source = response.body().source();
                    AsyncBody asyncBody = (AsyncBody)handler.apply(source);
                    future.complete(new OkHttpResponseImpl<AsyncBody>(response, asyncBody));
                }

                public void onFailure(Call call, IOException e) {
                    IOException t = e;
                    if (e instanceof InterruptedIOException && e.getCause() instanceof RejectedExecutionException) {
                        t = OkHttpClientImpl.this.wrapRejected((RejectedExecutionException)e.getCause());
                    }
                    future.completeExceptionally(t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw this.wrapRejected(e);
        }
        future.whenComplete((r, t) -> {
            if (future.isCancelled()) {
                call.cancel();
            }
        });
        return future;
    }

    private KubernetesClientException wrapRejected(RejectedExecutionException e) {
        return new KubernetesClientException("The okhttp client executor has been shutdown.  More than likely this is because the KubernetesClient.close method (see debug logging) has been called - please ensure that is intentional. Dispatcher: " + this.httpClient.dispatcher(), (Throwable)e);
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    private Request.Builder newRequestBuilder() {
        return new Request.Builder();
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        Function<BufferedSource, AsyncBody> handler = s -> new OkHttpAsyncBody<List<ByteBuffer>>(consumer, s, (Executor)this.httpClient.dispatcher().executorService()){

            @Override
            protected List<ByteBuffer> process(BufferedSource source) throws IOException {
                return Collections.singletonList(ByteBuffer.wrap(source.readByteArray(source.buffer().size())));
            }
        };
        return this.sendAsync((HttpRequest)request, handler);
    }

    Request.Builder requestBuilder(StandardHttpRequest request) {
        Request.Builder requestBuilder = this.newRequestBuilder();
        StandardHttpRequest.BodyContent body = request.body();
        if (body != null) {
            final String contentType = request.getContentType();
            if (body instanceof StandardHttpRequest.StringBodyContent) {
                requestBuilder.method(request.method(), RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (String)((StandardHttpRequest.StringBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                requestBuilder.method(request.method(), RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (byte[])((StandardHttpRequest.ByteArrayBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.InputStreamBodyContent) {
                final StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)body;
                requestBuilder.method(request.method(), new RequestBody(){

                    public void writeTo(BufferedSink sink) throws IOException {
                        try (BufferedInputStream bis = new BufferedInputStream(bodyContent.getContent());
                             Source source = Okio.source((InputStream)bis);){
                            sink.writeAll(source);
                        }
                    }

                    public MediaType contentType() {
                        return OkHttpClientImpl.parseMediaType(contentType);
                    }

                    public long contentLength() throws IOException {
                        return bodyContent.getLength();
                    }
                });
            } else {
                throw new AssertionError((Object)"Unsupported body content");
            }
        }
        request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> requestBuilder.addHeader((String)e.getKey(), v)));
        try {
            requestBuilder.url(request.uri().toURL());
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException(request.uri().toString(), e2);
        }
        if (request.isExpectContinue()) {
            requestBuilder.header("Expect", "100-Continue");
        }
        return requestBuilder;
    }

    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        Request.Builder requestBuilder = this.requestBuilder(standardWebSocketBuilder.asHttpRequest());
        if (standardWebSocketBuilder.getSubprotocol() != null) {
            requestBuilder.header("Sec-WebSocket-Protocol", standardWebSocketBuilder.getSubprotocol());
        }
        return OkHttpWebSocketImpl.buildAsync(this.httpClient, requestBuilder.build(), listener);
    }

    static class OkHttpResponseImpl<T>
    implements HttpResponse<T> {
        private final Response response;
        private T body;
        private Class<T> type;

        public OkHttpResponseImpl(Response response, T body) throws IOException {
            this.response = response;
            this.body = body;
        }

        public OkHttpResponseImpl(Response response, Class<T> type) throws IOException {
            this.response = response;
            this.type = type;
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                if (type == null) {
                    responseBody.close();
                } else {
                    this.body = type == String.class ? responseBody.string() : (type == Reader.class ? responseBody.charStream() : (type == byte[].class ? (T)responseBody.bytes() : responseBody.byteStream()));
                }
            }
        }

        public int code() {
            return this.response.code();
        }

        public T body() {
            return this.body;
        }

        public HttpRequest request() {
            String bodyString = null;
            Request request = this.response.request();
            if (request.body() != null) {
                Buffer buffer = new Buffer();
                try {
                    request.body().writeTo((BufferedSink)buffer);
                    bodyString = buffer.readUtf8();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new StandardHttpRequest(request.headers().toMultimap(), request.url().uri(), request.method(), bodyString);
        }

        public Optional<HttpResponse<?>> previousResponse() {
            Response previous = this.response.priorResponse() != null ? this.response.priorResponse() : this.response;
            previous = previous.networkResponse() != null ? previous.networkResponse() : previous;
            try {
                return Optional.ofNullable(previous == this.response ? null : new OkHttpResponseImpl<T>(previous, this.type));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public List<String> headers(String key) {
            return this.response.headers(key);
        }

        public Map<String, List<String>> headers() {
            return this.response.headers().toMultimap();
        }
    }

    static abstract class OkHttpAsyncBody<T>
    implements AsyncBody {
        private final AsyncBody.Consumer<T> consumer;
        private final BufferedSource source;
        private final CompletableFuture<Void> done = new CompletableFuture();
        private boolean consuming;
        private boolean requested;
        private final Executor executor;

        OkHttpAsyncBody(AsyncBody.Consumer<T> consumer, BufferedSource source, Executor executor) {
            this.consumer = consumer;
            this.source = source;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume() {
            OkHttpAsyncBody okHttpAsyncBody = this;
            synchronized (okHttpAsyncBody) {
                this.requested = true;
                if (this.consuming) {
                    return;
                }
                this.consuming = true;
            }
            try {
                this.executor.execute(this::doConsume);
            }
            catch (Exception e) {
                Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
                this.done.completeExceptionally(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doConsume() {
            try {
                while (true) {
                    OkHttpAsyncBody okHttpAsyncBody = this;
                    synchronized (okHttpAsyncBody) {
                        if (!this.requested || this.done.isDone()) {
                            this.consuming = false;
                            return;
                        }
                        this.requested = false;
                    }
                    if (!this.source.exhausted()) {
                        T value = this.process(this.source);
                        this.consumer.consume(value, (AsyncBody)this);
                        continue;
                    }
                    this.source.close();
                    this.done.complete(null);
                }
            }
            catch (Exception e) {
                Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
                this.done.completeExceptionally(e);
                return;
            }
        }

        public CompletableFuture<Void> done() {
            return this.done;
        }

        protected abstract T process(BufferedSource var1) throws IOException;

        public void cancel() {
            Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
            this.done.cancel(false);
        }
    }
}

