/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.log4j.lookup;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.log4j.lookup.Log4jConfig;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

final class ClientBuilder {
    public static final String KUBERNETES_LOG4J_USE_PROPERTIES = "kubernetes.log4j.useProperties";

    private ClientBuilder() {
    }

    public static KubernetesClient createClient() {
        Config config = ClientBuilder.kubernetesClientConfig(PropertiesUtil.getProperties());
        return config != null ? new KubernetesClientBuilder().withConfig(config).build() : null;
    }

    static Config kubernetesClientConfig(PropertiesUtil props) {
        try {
            Config base = Config.autoConfigure(null);
            if (Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_LOG4J_USE_PROPERTIES, (Boolean)false)) {
                Log4jConfig log4jConfig = new Log4jConfig(props, base);
                return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withApiVersion(log4jConfig.getApiVersion())).withCaCertData(log4jConfig.getCaCertData())).withCaCertFile(log4jConfig.getCaCertFile())).withClientCertData(log4jConfig.getClientCertData())).withClientCertFile(log4jConfig.getClientCertFile())).withClientKeyAlgo(log4jConfig.getClientKeyAlgo())).withClientKeyData(log4jConfig.getClientKeyData())).withClientKeyFile(log4jConfig.getClientKeyFile())).withClientKeyPassphrase(log4jConfig.getClientKeyPassphrase())).withConnectionTimeout(log4jConfig.getConnectionTimeout())).withHttpProxy(log4jConfig.getHttpProxy())).withHttpsProxy(log4jConfig.getHttpsProxy())).withLoggingInterval(log4jConfig.getLoggingInterval())).withMasterUrl(log4jConfig.getMasterUrl())).withNamespace(log4jConfig.getNamespace())).withNoProxy(log4jConfig.getNoProxy())).withPassword(log4jConfig.getPassword())).withProxyPassword(log4jConfig.getProxyPassword())).withProxyUsername(log4jConfig.getProxyUsername())).withRequestTimeout(log4jConfig.getRequestTimeout())).withTrustCerts(log4jConfig.isTrustCerts().booleanValue())).withUsername(log4jConfig.getUsername())).withWatchReconnectInterval(log4jConfig.getWatchReconnectInterval())).withWatchReconnectLimit(log4jConfig.getWatchReconnectLimit())).build();
            }
            return base;
        }
        catch (Exception e) {
            StatusLogger.getLogger().warn("An error occurred while retrieving Kubernetes Client configuration: {}.", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

