package io.fabric8.kubernetes.api.model.admission;

import io.fabric8.kubernetes.api.model.Status;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface AdmissionResponseFluent<A extends AdmissionResponseFluent<A>> extends Fluent<A>{


    public Boolean isAllowed();
    public A withAllowed(Boolean allowed);
    public Boolean hasAllowed();
    public A withNewAllowed(String arg1);
    public A withNewAllowed(boolean arg1);
    public A addToAuditAnnotations(String key,String value);
    public A addToAuditAnnotations(Map<String,String> map);
    public A removeFromAuditAnnotations(String key);
    public A removeFromAuditAnnotations(Map<String,String> map);
    public Map<String,String> getAuditAnnotations();
    public A withAuditAnnotations(Map<String,String> auditAnnotations);
    public Boolean hasAuditAnnotations();
    public String getPatch();
    public A withPatch(String patch);
    public Boolean hasPatch();
    public A withNewPatch(String arg1);
    public A withNewPatch(StringBuilder arg1);
    public A withNewPatch(StringBuffer arg1);
    public String getPatchType();
    public A withPatchType(String patchType);
    public Boolean hasPatchType();
    public A withNewPatchType(String arg1);
    public A withNewPatchType(StringBuilder arg1);
    public A withNewPatchType(StringBuffer arg1);
    public Status getStatus();
    public A withStatus(Status status);
    public Boolean hasStatus();
    public String getUid();
    public A withUid(String uid);
    public Boolean hasUid();
    public A withNewUid(String arg1);
    public A withNewUid(StringBuilder arg1);
    public A withNewUid(StringBuffer arg1);



}
