package io.fabric8.kubernetes.api.model.authorization.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NonResourceRuleFluent<A extends NonResourceRuleFluent<A>> extends Fluent<A> {


    public A addToNonResourceURLs(int index,String item);
    public A setToNonResourceURLs(int index,String item);
    public A addToNonResourceURLs(String... items);
    public A addAllToNonResourceURLs(Collection<String> items);
    public A removeFromNonResourceURLs(String... items);
    public A removeAllFromNonResourceURLs(Collection<String> items);
    public List<String> getNonResourceURLs();
    public String getNonResourceURL(int index);
    public String getFirstNonResourceURL();
    public String getLastNonResourceURL();
    public String getMatchingNonResourceURL(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNonResourceURL(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNonResourceURLs(List<String> nonResourceURLs);
    public A withNonResourceURLs(String... nonResourceURLs);
    public Boolean hasNonResourceURLs();
    public A addNewNonResourceURL(String arg1);
    public A addNewNonResourceURL(StringBuilder arg1);
    public A addNewNonResourceURL(StringBuffer arg1);
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();
    public A addNewVerb(String arg1);
    public A addNewVerb(StringBuilder arg1);
    public A addNewVerb(StringBuffer arg1);
}
