package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ValidatingWebhookBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluent<?> fluent;
    Boolean validationEnabled;

    public ValidatingWebhookBuilder() { 
        this(true);
    }


    public ValidatingWebhookBuilder(Boolean validationEnabled) { 
        this(new ValidatingWebhook(), validationEnabled);
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluent<?> fluent) { 
        this(fluent, true);
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ValidatingWebhook(), validationEnabled);
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook instance) { 
        this(fluent, instance, true);
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        fluent.withClientConfig(instance.getClientConfig()); 
        fluent.withFailurePolicy(instance.getFailurePolicy()); 
        fluent.withMatchPolicy(instance.getMatchPolicy()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
        fluent.withObjectSelector(instance.getObjectSelector()); 
        fluent.withRules(instance.getRules()); 
        fluent.withSideEffects(instance.getSideEffects()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook instance) { 
        this(instance,true);
    }


    public ValidatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withClientConfig(instance.getClientConfig()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withName(instance.getName()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook build() {
        ValidatingWebhook buildable = new ValidatingWebhook(fluent.getAdmissionReviewVersions(),fluent.getClientConfig(),fluent.getFailurePolicy(),fluent.getMatchPolicy(),fluent.getName(),fluent.getNamespaceSelector(),fluent.getObjectSelector(),fluent.getRules(),fluent.getSideEffects(),fluent.getTimeoutSeconds());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ValidatingWebhookBuilder that = (ValidatingWebhookBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
