package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WebhookClientConfigBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluent<?> fluent;
    Boolean validationEnabled;

    public WebhookClientConfigBuilder() { 
        this(true);
    }


    public WebhookClientConfigBuilder(Boolean validationEnabled) { 
        this(new WebhookClientConfig(), validationEnabled);
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new WebhookClientConfig(), validationEnabled);
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig instance) { 
        this(fluent, instance, true);
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCaBundle(instance.getCaBundle()); 
        fluent.withService(instance.getService()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig instance) { 
        this(instance,true);
    }


    public WebhookClientConfigBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCaBundle(instance.getCaBundle()); 
        this.withService(instance.getService()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.WebhookClientConfig build() {
        WebhookClientConfig buildable = new WebhookClientConfig(fluent.getCaBundle(),fluent.getService(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WebhookClientConfigBuilder that = (WebhookClientConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
