package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class SubjectAccessReviewSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectAccessReviewSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectAccessReviewSpecFluent<A> {

    private Map<String,ArrayList<String>> extra;
    private List<String> group = new ArrayList<String>();
    private io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder nonResourceAttributes;
    private io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;

    public SubjectAccessReviewSpecFluentImpl() { 
    }


    public SubjectAccessReviewSpecFluentImpl(io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectAccessReviewSpec instance) { 
        this.withExtra(instance.getExtra()); 
        this.withGroup(instance.getGroup()); 
        this.withNonResourceAttributes(instance.getNonResourceAttributes()); 
        this.withResourceAttributes(instance.getResourceAttributes()); 
        this.withUid(instance.getUid()); 
        this.withUser(instance.getUser()); 
    }


    public A addToExtra(String key,ArrayList<String> value) {
        if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap<String,ArrayList<String>>(); }
        if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
    }

    public A addToExtra(Map<String,ArrayList<String>> map) {
        if(this.extra == null && map != null) { this.extra = new LinkedHashMap<String,ArrayList<String>>(); }
        if(map != null) { this.extra.putAll(map);} return (A)this;
    }

    public A removeFromExtra(String key) {
        if(this.extra == null) { return (A) this; }
        if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
    }

    public A removeFromExtra(Map<String,ArrayList<String>> map) {
        if(this.extra == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
    }

    public Map<String,ArrayList<String>> getExtra() {
        return this.extra;
    }

    public A withExtra(Map<String,ArrayList<String>> extra) {
        if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap<String,ArrayList<String>>(extra);} return (A) this;
    }

    public Boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroup(int index,String item) {
        if (this.group == null) {this.group = new ArrayList<String>();}
        this.group.add(index, item);
        return (A)this;
    }

    public A setToGroup(int index,String item) {
        if (this.group == null) {this.group = new ArrayList<String>();}
        this.group.set(index, item); return (A)this;
    }

    public A addToGroup(String... items) {
        if (this.group == null) {this.group = new ArrayList<String>();}
        for (String item : items) {this.group.add(item);} return (A)this;
    }

    public A addAllToGroup(Collection<String> items) {
        if (this.group == null) {this.group = new ArrayList<String>();}
        for (String item : items) {this.group.add(item);} return (A)this;
    }

    public A removeFromGroup(String... items) {
        for (String item : items) {if (this.group!= null){ this.group.remove(item);}} return (A)this;
    }

    public A removeAllFromGroup(Collection<String> items) {
        for (String item : items) {if (this.group!= null){ this.group.remove(item);}} return (A)this;
    }

    public List<String> getGroup() {
        return this.group;
    }

    public String getGroup(int index) {
        return this.group.get(index);
    }

    public String getFirstGroup() {
        return this.group.get(0);
    }

    public String getLastGroup() {
        return this.group.get(group.size() - 1);
    }

    public String getMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: group) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: group) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGroup(List<String> group) {
        if (this.group != null) { _visitables.get("group").removeAll(this.group);}
        if (group != null) {this.group = new ArrayList<String>(); for (String item : group){this.addToGroup(item);}} else { this.group = null;} return (A) this;
    }

    public A withGroup(String... group) {
        if (this.group != null) {this.group.clear();}
        if (group != null) {for (String item :group){ this.addToGroup(item);}} return (A) this;
    }

    public Boolean hasGroup() {
        return group != null && !group.isEmpty();
    }

    public A addNewGroup(String arg1) {
        return (A)addToGroup(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1) {
        return (A)addToGroup(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1) {
        return (A)addToGroup(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNonResourceAttributes instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes!=null?this.nonResourceAttributes.build():null;
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes!=null?this.nonResourceAttributes.build():null;
    }

    public A withNonResourceAttributes(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes nonResourceAttributes) {
        _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        if (nonResourceAttributes!=null){ this.nonResourceAttributes= new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder(nonResourceAttributes); _visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);} return (A) this;
    }

    public Boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    public A withNewNonResourceAttributes(String path,String verb) {
        return (A)withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNestedImpl();
    }

    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes item) {
        return new NonResourceAttributesNestedImpl(item);
    }

    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
        return withNewNonResourceAttributesLike(getNonResourceAttributes());
    }

    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder().build());
    }

    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes item) {
        return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResourceAttributes instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes!=null?this.resourceAttributes.build():null;
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes!=null?this.resourceAttributes.build():null;
    }

    public A withResourceAttributes(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes resourceAttributes) {
        _visitables.get("resourceAttributes").remove(this.resourceAttributes);
        if (resourceAttributes!=null){ this.resourceAttributes= new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder(resourceAttributes); _visitables.get("resourceAttributes").add(this.resourceAttributes);} return (A) this;
    }

    public Boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNestedImpl();
    }

    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes item) {
        return new ResourceAttributesNestedImpl(item);
    }

    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
        return withNewResourceAttributesLike(getResourceAttributes());
    }

    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder().build());
    }

    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes item) {
        return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): item);
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl) o;
        if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (nonResourceAttributes != null ? !nonResourceAttributes.equals(that.nonResourceAttributes) :that.nonResourceAttributes != null) return false;
        if (resourceAttributes != null ? !resourceAttributes.equals(that.resourceAttributes) :that.resourceAttributes != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(extra,  group,  nonResourceAttributes,  resourceAttributes,  uid,  user,  super.hashCode());
    }

    public class NonResourceAttributesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder builder;

        NonResourceAttributesNestedImpl(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributes item) {
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder(this, item);
        }

        NonResourceAttributesNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceAttributesBuilder(this);
        }

        public N and() {
             return (N) SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(builder.build());
        }

        public N endNonResourceAttributes() {
             return and();
        }
    }


    public class ResourceAttributesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder builder;

        ResourceAttributesNestedImpl(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes item) {
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder(this, item);
        }

        ResourceAttributesNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder(this);
        }

        public N and() {
             return (N) SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(builder.build());
        }

        public N endResourceAttributes() {
             return and();
        }
    }


}
