package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public class TokenReviewStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent<A>{
  public TokenReviewStatusFluentImpl() {
  }
  public TokenReviewStatusFluentImpl(io.fabric8.kubernetes.api.model.authentication.TokenReviewStatus instance) {
    this.withAudiences(instance.getAudiences()); 
    this.withAuthenticated(instance.getAuthenticated()); 
    this.withError(instance.getError()); 
    this.withUser(instance.getUser()); 
  }
  private java.util.List<java.lang.String> audiences = new java.util.ArrayList<java.lang.String>();
  private java.lang.Boolean authenticated;
  private java.lang.String error;
  private io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder user;
  public A addToAudiences(java.lang.Integer index,java.lang.String item) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  public A setToAudiences(java.lang.Integer index,java.lang.String item) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    this.audiences.set(index, item); return (A)this;
  }
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A addAllToAudiences(java.util.Collection<java.lang.String> items) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A removeFromAudiences(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public A removeAllFromAudiences(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAudiences() {
    return this.audiences;
  }
  public java.lang.String getAudience(java.lang.Integer index) {
    return this.audiences.get(index);
  }
  public java.lang.String getFirstAudience() {
    return this.audiences.get(0);
  }
  public java.lang.String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  public java.lang.String getMatchingAudience(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: audiences) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAudience(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: audiences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAudiences(java.util.List<java.lang.String> audiences) {
    if (audiences != null) {this.audiences = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
  }
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {this.audiences.clear();}
    if (audiences != null) {for (java.lang.String item :audiences){ this.addToAudiences(item);}} return (A) this;
  }
  public java.lang.Boolean hasAudiences() {
    return audiences != null && !audiences.isEmpty();
  }
  public A addNewAudience(java.lang.String arg0) {
    return (A)addToAudiences(new String(arg0));
  }
  public java.lang.Boolean getAuthenticated() {
    return this.authenticated;
  }
  public A withAuthenticated(java.lang.Boolean authenticated) {
    this.authenticated=authenticated; return (A) this;
  }
  public java.lang.Boolean hasAuthenticated() {
    return this.authenticated != null;
  }
  public java.lang.String getError() {
    return this.error;
  }
  public A withError(java.lang.String error) {
    this.error=error; return (A) this;
  }
  public java.lang.Boolean hasError() {
    return this.error != null;
  }
  
  /**
   * Method is deprecated. use withError instead.
   */
  @java.lang.Deprecated
  public A withNewError(java.lang.String arg0) {
    return (A)withError(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.authentication.UserInfo getUser() {
    return this.user!=null?this.user.build():null;
  }
  public io.fabric8.kubernetes.api.model.authentication.UserInfo buildUser() {
    return this.user!=null?this.user.build():null;
  }
  public A withUser(io.fabric8.kubernetes.api.model.authentication.UserInfo user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
  }
  public java.lang.Boolean hasUser() {
    return this.user != null;
  }
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> withNewUser() {
    return new io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluentImpl.UserNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> withNewUserLike(io.fabric8.kubernetes.api.model.authentication.UserInfo item) {
    return new io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluentImpl.UserNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editUser() {
    return withNewUserLike(getUser());
  }
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editOrNewUser() {
    return withNewUserLike(getUser() != null ? getUser(): new io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(io.fabric8.kubernetes.api.model.authentication.UserInfo item) {
    return withNewUserLike(getUser() != null ? getUser(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TokenReviewStatusFluentImpl that = (TokenReviewStatusFluentImpl) o;
    if (audiences != null ? !audiences.equals(that.audiences) :that.audiences != null) return false;
    if (authenticated != null ? !authenticated.equals(that.authenticated) :that.authenticated != null) return false;
    if (error != null ? !error.equals(that.error) :that.error != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(audiences,  authenticated,  error,  user,  super.hashCode());
  }
  public class UserNestedImpl<N> extends io.fabric8.kubernetes.api.model.authentication.UserInfoFluentImpl<io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<N>> implements io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserNestedImpl(io.fabric8.kubernetes.api.model.authentication.UserInfo item) {
      this.builder = new io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder(this, item);
    }
    UserNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder(this);
    }
    io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder builder;
    public N and() {
      return (N) TokenReviewStatusFluentImpl.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}