package io.fabric8.kubernetes.api.model.admission.v1;

import io.fabric8.kubernetes.api.model.Status;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class AdmissionResponseFluentImpl<A extends io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseFluent<A>{
  public AdmissionResponseFluentImpl() {
  }
  public AdmissionResponseFluentImpl(io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponse instance) {
    this.withAllowed(instance.getAllowed()); 
    this.withAuditAnnotations(instance.getAuditAnnotations()); 
    this.withPatch(instance.getPatch()); 
    this.withPatchType(instance.getPatchType()); 
    this.withStatus(instance.getStatus()); 
    this.withUid(instance.getUid()); 
    this.withWarnings(instance.getWarnings()); 
  }
  private java.lang.Boolean allowed;
  private java.util.Map<java.lang.String,java.lang.String> auditAnnotations;
  private java.lang.String patch;
  private java.lang.String patchType;
  private io.fabric8.kubernetes.api.model.Status status;
  private java.lang.String uid;
  private java.util.List<java.lang.String> warnings = new java.util.ArrayList<java.lang.String>();
  public java.lang.Boolean getAllowed() {
    return this.allowed;
  }
  public A withAllowed(java.lang.Boolean allowed) {
    this.allowed=allowed; return (A) this;
  }
  public java.lang.Boolean hasAllowed() {
    return this.allowed != null;
  }
  public A addToAuditAnnotations(java.lang.String key,java.lang.String value) {
    if(this.auditAnnotations == null && key != null && value != null) { this.auditAnnotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.auditAnnotations.put(key, value);} return (A)this;
  }
  public A addToAuditAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.auditAnnotations == null && map != null) { this.auditAnnotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.auditAnnotations.putAll(map);} return (A)this;
  }
  public A removeFromAuditAnnotations(java.lang.String key) {
    if(this.auditAnnotations == null) { return (A) this; }
    if(key != null && this.auditAnnotations != null) {this.auditAnnotations.remove(key);} return (A)this;
  }
  public A removeFromAuditAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.auditAnnotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.auditAnnotations != null){this.auditAnnotations.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getAuditAnnotations() {
    return this.auditAnnotations;
  }
  public <K,V>A withAuditAnnotations(java.util.Map<java.lang.String,java.lang.String> auditAnnotations) {
    if (auditAnnotations == null) { this.auditAnnotations =  null;} else {this.auditAnnotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(auditAnnotations);} return (A) this;
  }
  public java.lang.Boolean hasAuditAnnotations() {
    return this.auditAnnotations != null;
  }
  public java.lang.String getPatch() {
    return this.patch;
  }
  public A withPatch(java.lang.String patch) {
    this.patch=patch; return (A) this;
  }
  public java.lang.Boolean hasPatch() {
    return this.patch != null;
  }
  
  /**
   * Method is deprecated. use withPatch instead.
   */
  @java.lang.Deprecated
  public A withNewPatch(java.lang.String arg0) {
    return (A)withPatch(new String(arg0));
  }
  public java.lang.String getPatchType() {
    return this.patchType;
  }
  public A withPatchType(java.lang.String patchType) {
    this.patchType=patchType; return (A) this;
  }
  public java.lang.Boolean hasPatchType() {
    return this.patchType != null;
  }
  
  /**
   * Method is deprecated. use withPatchType instead.
   */
  @java.lang.Deprecated
  public A withNewPatchType(java.lang.String arg0) {
    return (A)withPatchType(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.Status getStatus() {
    return this.status;
  }
  public A withStatus(io.fabric8.kubernetes.api.model.Status status) {
    this.status=status; return (A) this;
  }
  public java.lang.Boolean hasStatus() {
    return this.status != null;
  }
  public java.lang.String getUid() {
    return this.uid;
  }
  public A withUid(java.lang.String uid) {
    this.uid=uid; return (A) this;
  }
  public java.lang.Boolean hasUid() {
    return this.uid != null;
  }
  
  /**
   * Method is deprecated. use withUid instead.
   */
  @java.lang.Deprecated
  public A withNewUid(java.lang.String arg0) {
    return (A)withUid(new String(arg0));
  }
  public A addToWarnings(java.lang.Integer index,java.lang.String item) {
    if (this.warnings == null) {this.warnings = new java.util.ArrayList<java.lang.String>();}
    this.warnings.add(index, item);
    return (A)this;
  }
  public A setToWarnings(java.lang.Integer index,java.lang.String item) {
    if (this.warnings == null) {this.warnings = new java.util.ArrayList<java.lang.String>();}
    this.warnings.set(index, item); return (A)this;
  }
  public A addToWarnings(java.lang.String... items) {
    if (this.warnings == null) {this.warnings = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.warnings.add(item);} return (A)this;
  }
  public A addAllToWarnings(java.util.Collection<java.lang.String> items) {
    if (this.warnings == null) {this.warnings = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.warnings.add(item);} return (A)this;
  }
  public A removeFromWarnings(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.warnings!= null){ this.warnings.remove(item);}} return (A)this;
  }
  public A removeAllFromWarnings(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.warnings!= null){ this.warnings.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getWarnings() {
    return this.warnings;
  }
  public java.lang.String getWarning(java.lang.Integer index) {
    return this.warnings.get(index);
  }
  public java.lang.String getFirstWarning() {
    return this.warnings.get(0);
  }
  public java.lang.String getLastWarning() {
    return this.warnings.get(warnings.size() - 1);
  }
  public java.lang.String getMatchingWarning(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: warnings) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingWarning(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: warnings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWarnings(java.util.List<java.lang.String> warnings) {
    if (warnings != null) {this.warnings = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : warnings){this.addToWarnings(item);}} else { this.warnings = null;} return (A) this;
  }
  public A withWarnings(java.lang.String... warnings) {
    if (this.warnings != null) {this.warnings.clear();}
    if (warnings != null) {for (java.lang.String item :warnings){ this.addToWarnings(item);}} return (A) this;
  }
  public java.lang.Boolean hasWarnings() {
    return warnings != null && !warnings.isEmpty();
  }
  public A addNewWarning(java.lang.String arg0) {
    return (A)addToWarnings(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AdmissionResponseFluentImpl that = (AdmissionResponseFluentImpl) o;
    if (allowed != null ? !allowed.equals(that.allowed) :that.allowed != null) return false;
    if (auditAnnotations != null ? !auditAnnotations.equals(that.auditAnnotations) :that.auditAnnotations != null) return false;
    if (patch != null ? !patch.equals(that.patch) :that.patch != null) return false;
    if (patchType != null ? !patchType.equals(that.patchType) :that.patchType != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (warnings != null ? !warnings.equals(that.warnings) :that.warnings != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowed,  auditAnnotations,  patch,  patchType,  status,  uid,  warnings,  super.hashCode());
  }
  
}