package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AdmissionReviewBuilder extends AdmissionReviewFluent<AdmissionReviewBuilder> implements VisitableBuilder<AdmissionReview,AdmissionReviewBuilder>{
  public AdmissionReviewBuilder() {
    this(new AdmissionReview());
  }
  
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent) {
    this(fluent, new AdmissionReview());
  }
  
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent,AdmissionReview instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AdmissionReviewBuilder(AdmissionReview instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AdmissionReviewFluent<?> fluent;
  
  public AdmissionReview build() {
    AdmissionReview buildable = new AdmissionReview(fluent.getApiVersion(),fluent.getKind(),fluent.getRequest(),fluent.buildResponse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}