package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleWithOperationsBuilder extends RuleWithOperationsFluentImpl<RuleWithOperationsBuilder> implements VisitableBuilder<RuleWithOperations,RuleWithOperationsBuilder>{
  public RuleWithOperationsBuilder() {
    this(false);
  }
  public RuleWithOperationsBuilder(Boolean validationEnabled) {
    this(new RuleWithOperations(), validationEnabled);
  }
  public RuleWithOperationsBuilder(RuleWithOperationsFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleWithOperationsBuilder(RuleWithOperationsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuleWithOperations(), validationEnabled);
  }
  public RuleWithOperationsBuilder(RuleWithOperationsFluent<?> fluent,RuleWithOperations instance) {
    this(fluent, instance, false);
  }
  public RuleWithOperationsBuilder(RuleWithOperationsFluent<?> fluent,RuleWithOperations instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiGroups(instance.getApiGroups());
      fluent.withApiVersions(instance.getApiVersions());
      fluent.withOperations(instance.getOperations());
      fluent.withResources(instance.getResources());
      fluent.withScope(instance.getScope());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuleWithOperationsBuilder(RuleWithOperations instance) {
    this(instance,false);
  }
  public RuleWithOperationsBuilder(RuleWithOperations instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withApiVersions(instance.getApiVersions());
      this.withOperations(instance.getOperations());
      this.withResources(instance.getResources());
      this.withScope(instance.getScope());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuleWithOperationsFluent<?> fluent;
  Boolean validationEnabled;
  public RuleWithOperations build() {
    RuleWithOperations buildable = new RuleWithOperations(fluent.getApiGroups(),fluent.getApiVersions(),fluent.getOperations(),fluent.getResources(),fluent.getScope());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}