package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicyBindingListBuilder extends ValidatingAdmissionPolicyBindingListFluentImpl<ValidatingAdmissionPolicyBindingListBuilder> implements VisitableBuilder<ValidatingAdmissionPolicyBindingList,ValidatingAdmissionPolicyBindingListBuilder>{
  public ValidatingAdmissionPolicyBindingListBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicyBindingList(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicyBindingList(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingListFluent<?> fluent,ValidatingAdmissionPolicyBindingList instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingListFluent<?> fluent,ValidatingAdmissionPolicyBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingList instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicyBindingListBuilder(ValidatingAdmissionPolicyBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicyBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicyBindingList build() {
    ValidatingAdmissionPolicyBindingList buildable = new ValidatingAdmissionPolicyBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}