package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicyListBuilder extends ValidatingAdmissionPolicyListFluentImpl<ValidatingAdmissionPolicyListBuilder> implements VisitableBuilder<ValidatingAdmissionPolicyList,ValidatingAdmissionPolicyListBuilder>{
  public ValidatingAdmissionPolicyListBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicyListBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicyList(), validationEnabled);
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicyList(), validationEnabled);
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyListFluent<?> fluent,ValidatingAdmissionPolicyList instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyListFluent<?> fluent,ValidatingAdmissionPolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyList instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicyListBuilder(ValidatingAdmissionPolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicyList build() {
    ValidatingAdmissionPolicyList buildable = new ValidatingAdmissionPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}