package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenRequestStatusBuilder extends TokenRequestStatusFluentImpl<TokenRequestStatusBuilder> implements VisitableBuilder<TokenRequestStatus,TokenRequestStatusBuilder>{
  public TokenRequestStatusBuilder() {
    this(false);
  }
  public TokenRequestStatusBuilder(Boolean validationEnabled) {
    this(new TokenRequestStatus(), validationEnabled);
  }
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenRequestStatus(), validationEnabled);
  }
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent,TokenRequestStatus instance) {
    this(fluent, instance, false);
  }
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent,TokenRequestStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withExpirationTimestamp(instance.getExpirationTimestamp());
      fluent.withToken(instance.getToken());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenRequestStatusBuilder(TokenRequestStatus instance) {
    this(instance,false);
  }
  public TokenRequestStatusBuilder(TokenRequestStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withExpirationTimestamp(instance.getExpirationTimestamp());
      this.withToken(instance.getToken());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenRequestStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TokenRequestStatus build() {
    TokenRequestStatus buildable = new TokenRequestStatus(fluent.getExpirationTimestamp(),fluent.getToken());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}