package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NonResourceRuleBuilder extends NonResourceRuleFluentImpl<NonResourceRuleBuilder> implements VisitableBuilder<NonResourceRule,NonResourceRuleBuilder>{
  public NonResourceRuleBuilder() {
    this(false);
  }
  public NonResourceRuleBuilder(Boolean validationEnabled) {
    this(new NonResourceRule(), validationEnabled);
  }
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NonResourceRule(), validationEnabled);
  }
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance) {
    this(fluent, instance, false);
  }
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNonResourceURLs(instance.getNonResourceURLs());
      fluent.withVerbs(instance.getVerbs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NonResourceRuleBuilder(NonResourceRule instance) {
    this(instance,false);
  }
  public NonResourceRuleBuilder(NonResourceRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNonResourceURLs(instance.getNonResourceURLs());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NonResourceRuleFluent<?> fluent;
  Boolean validationEnabled;
  public NonResourceRule build() {
    NonResourceRule buildable = new NonResourceRule(fluent.getNonResourceURLs(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}