package io.fabric8.kubernetes.api.model.authorization.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubjectAccessReviewSpecFluentImpl<A extends SubjectAccessReviewSpecFluent<A>> extends BaseFluent<A> implements SubjectAccessReviewSpecFluent<A>{
  public SubjectAccessReviewSpecFluentImpl() {
  }
  public SubjectAccessReviewSpecFluentImpl(SubjectAccessReviewSpec instance) {
    if (instance != null) {
      this.withExtra(instance.getExtra());
      this.withGroups(instance.getGroups());
      this.withNonResourceAttributes(instance.getNonResourceAttributes());
      this.withResourceAttributes(instance.getResourceAttributes());
      this.withUid(instance.getUid());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,ArrayList<String>> extra;
  private List<String> groups = new ArrayList<String>();
  private NonResourceAttributesBuilder nonResourceAttributes;
  private ResourceAttributesBuilder resourceAttributes;
  private String uid;
  private String user;
  private Map<String,Object> additionalProperties;
  public A addToExtra(String key,ArrayList<String> value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  public A addToExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  public A removeFromExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getExtra() {
    return this.extra;
  }
  public <K,V>A withExtra(Map<String,ArrayList<String>> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap(extra);} return (A) this;
  }
  public Boolean hasExtra() {
    return this.extra != null;
  }
  public A addToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(int index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear(); _visitables.remove("groups"); }
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildNonResourceAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public NonResourceAttributes getNonResourceAttributes() {
    return this.nonResourceAttributes!=null ?this.nonResourceAttributes.build():null;
  }
  public NonResourceAttributes buildNonResourceAttributes() {
    return this.nonResourceAttributes!=null ?this.nonResourceAttributes.build():null;
  }
  public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
    _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
    if (nonResourceAttributes!=null){ this.nonResourceAttributes= new NonResourceAttributesBuilder(nonResourceAttributes); _visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);} else { this.nonResourceAttributes = null; _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes); } return (A) this;
  }
  public Boolean hasNonResourceAttributes() {
    return this.nonResourceAttributes != null;
  }
  public A withNewNonResourceAttributes(String path,String verb) {
    return (A)withNonResourceAttributes(new NonResourceAttributes(path, verb));
  }
  public SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
    return new SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNestedImpl();
  }
  public SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
    return new SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNestedImpl(item);
  }
  public SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<A> editNonResourceAttributes() {
    return withNewNonResourceAttributesLike(getNonResourceAttributes());
  }
  public SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
    return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): new NonResourceAttributesBuilder().build());
  }
  public SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
    return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceAttributes getResourceAttributes() {
    return this.resourceAttributes!=null ?this.resourceAttributes.build():null;
  }
  public ResourceAttributes buildResourceAttributes() {
    return this.resourceAttributes!=null ?this.resourceAttributes.build():null;
  }
  public A withResourceAttributes(ResourceAttributes resourceAttributes) {
    _visitables.get("resourceAttributes").remove(this.resourceAttributes);
    if (resourceAttributes!=null){ this.resourceAttributes= new ResourceAttributesBuilder(resourceAttributes); _visitables.get("resourceAttributes").add(this.resourceAttributes);} else { this.resourceAttributes = null; _visitables.get("resourceAttributes").remove(this.resourceAttributes); } return (A) this;
  }
  public Boolean hasResourceAttributes() {
    return this.resourceAttributes != null;
  }
  public SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<A> withNewResourceAttributes() {
    return new SubjectAccessReviewSpecFluentImpl.ResourceAttributesNestedImpl();
  }
  public SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
    return new SubjectAccessReviewSpecFluentImpl.ResourceAttributesNestedImpl(item);
  }
  public SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<A> editResourceAttributes() {
    return withNewResourceAttributesLike(getResourceAttributes());
  }
  public SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<A> editOrNewResourceAttributes() {
    return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): new ResourceAttributesBuilder().build());
  }
  public SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
    return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): item);
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public String getUser() {
    return this.user;
  }
  public A withUser(String user) {
    this.user=user; return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl) o;
    if (!java.util.Objects.equals(extra, that.extra)) return false;

    if (!java.util.Objects.equals(groups, that.groups)) return false;

    if (!java.util.Objects.equals(nonResourceAttributes, that.nonResourceAttributes)) return false;

    if (!java.util.Objects.equals(resourceAttributes, that.resourceAttributes)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(extra,  groups,  nonResourceAttributes,  resourceAttributes,  uid,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (nonResourceAttributes != null) { sb.append("nonResourceAttributes:"); sb.append(nonResourceAttributes + ","); }
    if (resourceAttributes != null) { sb.append("resourceAttributes:"); sb.append(resourceAttributes + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NonResourceAttributesNestedImpl<N> extends NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNested<N>,Nested<N>{
    NonResourceAttributesNestedImpl(NonResourceAttributes item) {
      this.builder = new NonResourceAttributesBuilder(this, item);
    }
    NonResourceAttributesNestedImpl() {
      this.builder = new NonResourceAttributesBuilder(this);
    }
    NonResourceAttributesBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(builder.build());
    }
    public N endNonResourceAttributes() {
      return and();
    }
    
  }
  class ResourceAttributesNestedImpl<N> extends ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluentImpl.ResourceAttributesNested<N>,Nested<N>{
    ResourceAttributesNestedImpl(ResourceAttributes item) {
      this.builder = new ResourceAttributesBuilder(this, item);
    }
    ResourceAttributesNestedImpl() {
      this.builder = new ResourceAttributesBuilder(this);
    }
    ResourceAttributesBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(builder.build());
    }
    public N endResourceAttributes() {
      return and();
    }
    
  }
  
}