package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectAccessReviewStatusBuilder extends SubjectAccessReviewStatusFluentImpl<SubjectAccessReviewStatusBuilder> implements VisitableBuilder<SubjectAccessReviewStatus,SubjectAccessReviewStatusBuilder>{
  public SubjectAccessReviewStatusBuilder() {
    this(false);
  }
  public SubjectAccessReviewStatusBuilder(Boolean validationEnabled) {
    this(new SubjectAccessReviewStatus(), validationEnabled);
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectAccessReviewStatus(), validationEnabled);
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatusFluent<?> fluent,SubjectAccessReviewStatus instance) {
    this(fluent, instance, false);
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatusFluent<?> fluent,SubjectAccessReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAllowed(instance.getAllowed());
      fluent.withDenied(instance.getDenied());
      fluent.withEvaluationError(instance.getEvaluationError());
      fluent.withReason(instance.getReason());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatus instance) {
    this(instance,false);
  }
  public SubjectAccessReviewStatusBuilder(SubjectAccessReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAllowed(instance.getAllowed());
      this.withDenied(instance.getDenied());
      this.withEvaluationError(instance.getEvaluationError());
      this.withReason(instance.getReason());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectAccessReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectAccessReviewStatus build() {
    SubjectAccessReviewStatus buildable = new SubjectAccessReviewStatus(fluent.getAllowed(),fluent.getDenied(),fluent.getEvaluationError(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}