package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NonResourceAttributesBuilder extends NonResourceAttributesFluentImpl<NonResourceAttributesBuilder> implements VisitableBuilder<NonResourceAttributes,NonResourceAttributesBuilder>{
  public NonResourceAttributesBuilder() {
    this(false);
  }
  public NonResourceAttributesBuilder(Boolean validationEnabled) {
    this(new NonResourceAttributes(), validationEnabled);
  }
  public NonResourceAttributesBuilder(NonResourceAttributesFluent<?> fluent) {
    this(fluent, false);
  }
  public NonResourceAttributesBuilder(NonResourceAttributesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NonResourceAttributes(), validationEnabled);
  }
  public NonResourceAttributesBuilder(NonResourceAttributesFluent<?> fluent,NonResourceAttributes instance) {
    this(fluent, instance, false);
  }
  public NonResourceAttributesBuilder(NonResourceAttributesFluent<?> fluent,NonResourceAttributes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPath(instance.getPath());
      fluent.withVerb(instance.getVerb());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NonResourceAttributesBuilder(NonResourceAttributes instance) {
    this(instance,false);
  }
  public NonResourceAttributesBuilder(NonResourceAttributes instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPath(instance.getPath());
      this.withVerb(instance.getVerb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NonResourceAttributesFluent<?> fluent;
  Boolean validationEnabled;
  public NonResourceAttributes build() {
    NonResourceAttributes buildable = new NonResourceAttributes(fluent.getPath(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}