/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MutatingWebhookConfigurationFluent<A extends MutatingWebhookConfigurationFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<MutatingWebhookBuilder> webhooks = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MutatingWebhookConfigurationFluent() {
    }

    public MutatingWebhookConfigurationFluent(MutatingWebhookConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MutatingWebhookConfiguration instance) {
        MutatingWebhookConfiguration mutatingWebhookConfiguration = instance = instance != null ? instance : new MutatingWebhookConfiguration();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withWebhooks(instance.getWebhooks());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withWebhooks(instance.getWebhooks());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToWebhooks(int index, MutatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get((Object)"webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get((Object)"webhooks").add(index, builder);
            this.webhooks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWebhooks(int index, MutatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get((Object)"webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get((Object)"webhooks").set(index, builder);
            this.webhooks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWebhooks(MutatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get((Object)"webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWebhooks(Collection<MutatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get((Object)"webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWebhooks(MutatingWebhook ... items) {
        if (this.webhooks == null) {
            return (A)((Object)this);
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get((Object)"webhooks").remove((Object)builder);
            this.webhooks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWebhooks(Collection<MutatingWebhook> items) {
        if (this.webhooks == null) {
            return (A)((Object)this);
        }
        for (MutatingWebhook item : items) {
            MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
            this._visitables.get((Object)"webhooks").remove((Object)builder);
            this.webhooks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWebhooks(Predicate<MutatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)((Object)this);
        }
        Iterator<MutatingWebhookBuilder> each = this.webhooks.iterator();
        List visitables = this._visitables.get((Object)"webhooks");
        while (each.hasNext()) {
            MutatingWebhookBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MutatingWebhook> buildWebhooks() {
        return this.webhooks != null ? MutatingWebhookConfigurationFluent.build(this.webhooks) : null;
    }

    public MutatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    public MutatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    public MutatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    public MutatingWebhook buildMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        for (MutatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        for (MutatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWebhooks(List<MutatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get((Object)"webhooks").clear();
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList();
            for (MutatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)((Object)this);
    }

    public A withWebhooks(MutatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
            this._visitables.remove((Object)"webhooks");
        }
        if (webhooks != null) {
            for (MutatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    public WebhooksNested<A> addNewWebhook() {
        return new WebhooksNested(-1, null);
    }

    public WebhooksNested<A> addNewWebhookLike(MutatingWebhook item) {
        return new WebhooksNested(-1, item);
    }

    public WebhooksNested<A> setNewWebhookLike(int index, MutatingWebhook item) {
        return new WebhooksNested(index, item);
    }

    public WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    public WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public WebhooksNested<A> editMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.test(this.webhooks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutatingWebhookConfigurationFluent that = (MutatingWebhookConfigurationFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.webhooks, that.webhooks)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.webhooks != null && !this.webhooks.isEmpty()) {
            sb.append("webhooks:");
            sb.append(this.webhooks + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WebhooksNested<N>
    extends MutatingWebhookFluent<WebhooksNested<N>>
    implements Nested<N> {
        MutatingWebhookBuilder builder;
        int index;

        WebhooksNested(int index, MutatingWebhook item) {
            this.index = index;
            this.builder = new MutatingWebhookBuilder(this, item);
        }

        public N and() {
            return (N)MutatingWebhookConfigurationFluent.this.setToWebhooks(this.index, this.builder.build());
        }

        public N endWebhook() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)MutatingWebhookConfigurationFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

