package io.fabric8.kubernetes.api.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenRequestStatusFluent<A extends TokenRequestStatusFluent<A>> extends BaseFluent<A>{
  public TokenRequestStatusFluent() {
  }
  
  public TokenRequestStatusFluent(TokenRequestStatus instance) {
    this.copyInstance(instance);
  }
  private String expirationTimestamp;
  private String token;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenRequestStatus instance) {
    instance = (instance != null ? instance : new TokenRequestStatus());
    if (instance != null) {
          this.withExpirationTimestamp(instance.getExpirationTimestamp());
          this.withToken(instance.getToken());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getExpirationTimestamp() {
    return this.expirationTimestamp;
  }
  
  public A withExpirationTimestamp(String expirationTimestamp) {
    this.expirationTimestamp = expirationTimestamp;
    return (A) this;
  }
  
  public boolean hasExpirationTimestamp() {
    return this.expirationTimestamp != null;
  }
  
  public String getToken() {
    return this.token;
  }
  
  public A withToken(String token) {
    this.token = token;
    return (A) this;
  }
  
  public boolean hasToken() {
    return this.token != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenRequestStatusFluent that = (TokenRequestStatusFluent) o;
    if (!java.util.Objects.equals(expirationTimestamp, that.expirationTimestamp)) return false;
    if (!java.util.Objects.equals(token, that.token)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(expirationTimestamp,  token,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (expirationTimestamp != null) { sb.append("expirationTimestamp:"); sb.append(expirationTimestamp + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}