package io.fabric8.kubernetes.api.model.authorization.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceAttributesFluent<A extends ResourceAttributesFluent<A>> extends BaseFluent<A>{
  public ResourceAttributesFluent() {
  }
  
  public ResourceAttributesFluent(ResourceAttributes instance) {
    this.copyInstance(instance);
  }
  private FieldSelectorAttributesBuilder fieldSelector;
  private String group;
  private LabelSelectorAttributesBuilder labelSelector;
  private String name;
  private String namespace;
  private String resource;
  private String subresource;
  private String verb;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceAttributes instance) {
    instance = (instance != null ? instance : new ResourceAttributes());
    if (instance != null) {
          this.withFieldSelector(instance.getFieldSelector());
          this.withGroup(instance.getGroup());
          this.withLabelSelector(instance.getLabelSelector());
          this.withName(instance.getName());
          this.withNamespace(instance.getNamespace());
          this.withResource(instance.getResource());
          this.withSubresource(instance.getSubresource());
          this.withVerb(instance.getVerb());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public FieldSelectorAttributes buildFieldSelector() {
    return this.fieldSelector != null ? this.fieldSelector.build() : null;
  }
  
  public A withFieldSelector(FieldSelectorAttributes fieldSelector) {
    this._visitables.remove("fieldSelector");
    if (fieldSelector != null) {
        this.fieldSelector = new FieldSelectorAttributesBuilder(fieldSelector);
        this._visitables.get("fieldSelector").add(this.fieldSelector);
    } else {
        this.fieldSelector = null;
        this._visitables.get("fieldSelector").remove(this.fieldSelector);
    }
    return (A) this;
  }
  
  public boolean hasFieldSelector() {
    return this.fieldSelector != null;
  }
  
  public FieldSelectorNested<A> withNewFieldSelector() {
    return new FieldSelectorNested(null);
  }
  
  public FieldSelectorNested<A> withNewFieldSelectorLike(FieldSelectorAttributes item) {
    return new FieldSelectorNested(item);
  }
  
  public FieldSelectorNested<A> editFieldSelector() {
    return withNewFieldSelectorLike(java.util.Optional.ofNullable(buildFieldSelector()).orElse(null));
  }
  
  public FieldSelectorNested<A> editOrNewFieldSelector() {
    return withNewFieldSelectorLike(java.util.Optional.ofNullable(buildFieldSelector()).orElse(new FieldSelectorAttributesBuilder().build()));
  }
  
  public FieldSelectorNested<A> editOrNewFieldSelectorLike(FieldSelectorAttributes item) {
    return withNewFieldSelectorLike(java.util.Optional.ofNullable(buildFieldSelector()).orElse(item));
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public LabelSelectorAttributes buildLabelSelector() {
    return this.labelSelector != null ? this.labelSelector.build() : null;
  }
  
  public A withLabelSelector(LabelSelectorAttributes labelSelector) {
    this._visitables.remove("labelSelector");
    if (labelSelector != null) {
        this.labelSelector = new LabelSelectorAttributesBuilder(labelSelector);
        this._visitables.get("labelSelector").add(this.labelSelector);
    } else {
        this.labelSelector = null;
        this._visitables.get("labelSelector").remove(this.labelSelector);
    }
    return (A) this;
  }
  
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  
  public LabelSelectorNested<A> withNewLabelSelector() {
    return new LabelSelectorNested(null);
  }
  
  public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelectorAttributes item) {
    return new LabelSelectorNested(item);
  }
  
  public LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(null));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(new LabelSelectorAttributesBuilder().build()));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelectorAttributes item) {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource = resource;
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public String getSubresource() {
    return this.subresource;
  }
  
  public A withSubresource(String subresource) {
    this.subresource = subresource;
    return (A) this;
  }
  
  public boolean hasSubresource() {
    return this.subresource != null;
  }
  
  public String getVerb() {
    return this.verb;
  }
  
  public A withVerb(String verb) {
    this.verb = verb;
    return (A) this;
  }
  
  public boolean hasVerb() {
    return this.verb != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceAttributesFluent that = (ResourceAttributesFluent) o;
    if (!java.util.Objects.equals(fieldSelector, that.fieldSelector)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(subresource, that.subresource)) return false;
    if (!java.util.Objects.equals(verb, that.verb)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fieldSelector,  group,  labelSelector,  name,  namespace,  resource,  subresource,  verb,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fieldSelector != null) { sb.append("fieldSelector:"); sb.append(fieldSelector + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (subresource != null) { sb.append("subresource:"); sb.append(subresource + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FieldSelectorNested<N> extends FieldSelectorAttributesFluent<FieldSelectorNested<N>> implements Nested<N>{
    FieldSelectorNested(FieldSelectorAttributes item) {
      this.builder = new FieldSelectorAttributesBuilder(this, item);
    }
    FieldSelectorAttributesBuilder builder;
    
    public N and() {
      return (N) ResourceAttributesFluent.this.withFieldSelector(builder.build());
    }
    
    public N endFieldSelector() {
      return and();
    }
    
  
  }
  public class LabelSelectorNested<N> extends LabelSelectorAttributesFluent<LabelSelectorNested<N>> implements Nested<N>{
    LabelSelectorNested(LabelSelectorAttributes item) {
      this.builder = new LabelSelectorAttributesBuilder(this, item);
    }
    LabelSelectorAttributesBuilder builder;
    
    public N and() {
      return (N) ResourceAttributesFluent.this.withLabelSelector(builder.build());
    }
    
    public N endLabelSelector() {
      return and();
    }
    
  
  }

}