package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BoundObjectReferenceBuilder extends BoundObjectReferenceFluent<BoundObjectReferenceBuilder> implements VisitableBuilder<BoundObjectReference,BoundObjectReferenceBuilder>{
  public BoundObjectReferenceBuilder() {
    this(new BoundObjectReference());
  }
  
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent) {
    this(fluent, new BoundObjectReference());
  }
  
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent,BoundObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BoundObjectReferenceBuilder(BoundObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BoundObjectReferenceFluent<?> fluent;
  
  public BoundObjectReference build() {
    BoundObjectReference buildable = new BoundObjectReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}