/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.annotator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import io.fabric8.kubernetes.model.annotation.PackageSuffix;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesCoreTypeAnnotator
extends Jackson2Annotator {
    protected static final String ANNOTATION_VALUE = "value";
    protected static final String API_VERSION = "apiVersion";
    protected static final String METADATA = "metadata";
    protected static final String KIND = "kind";
    public static final String CORE_PACKAGE = "core";
    public static final String OPENSHIFT_PACKAGE = "openshift";
    protected final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    protected final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();
    protected String moduleName = null;

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray(ANNOTATION_VALUE);
        annotationValue.param(API_VERSION);
        annotationValue.param(KIND);
        annotationValue.param(METADATA);
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            String next = (String)properties.next();
            if (next.equals(API_VERSION) || next.equals(KIND) || next.equals(METADATA)) continue;
            annotationValue.param(next);
        }
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        this.processBuildable(clazz);
        if (clazz.fields().containsKey(KIND) && clazz.fields().containsKey(METADATA)) {
            String resourceName;
            if (clazz.name().endsWith("List")) {
                resourceName = clazz.name().substring(0, clazz.name().length() - 4);
                this.pendingLists.put(resourceName, clazz);
            } else {
                resourceName = clazz.name();
                this.pendingResources.put(clazz.name(), clazz);
            }
            if (this.pendingResources.containsKey(resourceName) && this.pendingLists.containsKey(resourceName)) {
                JDefinedClass resourceClass = this.pendingResources.get(resourceName);
                JDefinedClass resourceListClass = this.pendingLists.get(resourceName);
                String apiVersion = propertiesNode.get(API_VERSION).get("default").toString().replaceAll(Pattern.quote("\""), "");
                String apiGroup = "";
                if (apiVersion.contains("/")) {
                    apiGroup = apiVersion.substring(0, apiVersion.lastIndexOf(47));
                    apiVersion = apiVersion.substring(apiGroup.length() + 1);
                }
                String packageSuffix = this.getPackageSuffix(apiVersion);
                resourceClass.annotate(ApiVersion.class).param(ANNOTATION_VALUE, apiVersion);
                resourceClass.annotate(ApiGroup.class).param(ANNOTATION_VALUE, apiGroup);
                resourceClass.annotate(PackageSuffix.class).param(ANNOTATION_VALUE, packageSuffix);
                resourceListClass.annotate(ApiVersion.class).param(ANNOTATION_VALUE, apiVersion);
                resourceListClass.annotate(ApiGroup.class).param(ANNOTATION_VALUE, apiGroup);
                resourceListClass.annotate(PackageSuffix.class).param(ANNOTATION_VALUE, packageSuffix);
                this.pendingLists.remove(resourceName);
                this.pendingResources.remove(resourceName);
                this.addClassesToPropertyFiles(resourceClass);
            }
        }
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
        if (this.moduleName == null) {
            this.moduleName = schema.get("$module").textValue();
        }
        if (schema.has("serializer")) {
            this.annotateSerde(clazz, JsonSerialize.class, schema.get("serializer").asText());
        }
        if (schema.has("deserializer")) {
            this.annotateSerde(clazz, JsonDeserialize.class, schema.get("deserializer").asText());
        } else {
            clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        }
        super.propertyInclusion(clazz, schema);
    }

    private void annotateSerde(JDefinedClass clazz, Class<? extends Annotation> annotation, String usingClassName) {
        if (!usingClassName.endsWith(".class")) {
            usingClassName = usingClassName + ".class";
        }
        clazz.annotate(annotation).param("using", (JExpression)this.literalExpression(usingClassName));
    }

    private JExpressionImpl literalExpression(final String literal) {
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p(literal);
            }
        };
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param(ANNOTATION_VALUE, (Enum)JsonInclude.Include.NON_EMPTY);
        }
    }

    protected void processBuildable(JDefinedClass clazz) {
        try {
            clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", false).param("generateBuilderPackage", true).param("lazyCollectionInitEnabled", false).param("builderPackage", "io.fabric8.kubernetes.api.builder").annotationParam("inline", Inline.class).param("type", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Doneable")).param("prefix", "Doneable").param(ANNOTATION_VALUE, "done");
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    protected void addClassesToPropertyFiles(JDefinedClass clazz) {
        String packageCategory = this.getPackageCategory(clazz.getPackage().name());
        if (this.moduleName.equals(packageCategory)) {
            JAnnotationArrayMember arrayMember = clazz.annotate(VelocityTransformations.class).paramArray(ANNOTATION_VALUE);
            arrayMember.annotate(VelocityTransformation.class).param(ANNOTATION_VALUE, "/manifest.vm").param("outputPath", this.moduleName + ".properties").param("gather", true);
        }
    }

    private String getPackageCategory(String packageName) {
        if (packageName.isEmpty()) {
            return null;
        }
        if (packageName.equals("io.fabric8.kubernetes.api.model")) {
            return CORE_PACKAGE;
        }
        if (packageName.equals("io.fabric8.openshift.api.model")) {
            return OPENSHIFT_PACKAGE;
        }
        String[] parts = packageName.split("\\.");
        if (parts.length < 6) {
            throw new IllegalArgumentException("Invalid package name encountered: " + packageName);
        }
        return parts[5];
    }

    private String getPackageSuffix(String apiVersion) {
        return "." + this.moduleName + "." + apiVersion;
    }
}

