/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.annotator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesTypeAnnotator
extends Jackson2Annotator {
    private final String envNamePattern = "[-._a-zA-Z][-._a-zA-Z0-9]*";
    private final String nameIsDNS952LabelPattern = "[a-z]([-a-z0-9]*[a-z0-9])?";
    private final String nameIsDNS1123LabelPattern = "[a-z0-9]([-a-z0-9]*[a-z0-9])?";
    private final int nameIsDNS1123LabelLength = 63;
    private final String nameIsDNS1123SubdomainPattern = "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    private final int nameIsDNS1123SubdomainLength = 253;
    private final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        annotationValue.param("apiVersion");
        annotationValue.param("kind");
        annotationValue.param("metadata");
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            String next = (String)properties.next();
            if (next.equals("apiVersion") || next.equals("kind") || next.equals("metadata")) continue;
            annotationValue.param(next);
        }
        clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        try {
            clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", true).param("generateBuilderPackage", true).param("builderPackage", "io.fabric8.kubernetes.api.builder").annotationParam("inline", Inline.class).param("type", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Doneable")).param("prefix", "Doneable").param("value", "done");
            this.annotateMetatadataValidator(clazz);
            this.envNameValidator(clazz);
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
        if (clazz.fields().containsKey("kind") && clazz.fields().containsKey("metadata")) {
            String resourceName;
            if (clazz.name().endsWith("List")) {
                resourceName = clazz.name().substring(0, clazz.name().length() - 4);
                this.pendingLists.put(resourceName, clazz);
            } else {
                resourceName = clazz.name();
                this.pendingResources.put(clazz.name(), clazz);
            }
            if (this.pendingResources.containsKey(resourceName) && this.pendingLists.containsKey(resourceName)) {
                JDefinedClass resourceClass = this.pendingResources.get(resourceName);
                JDefinedClass resourceListClass = this.pendingLists.get(resourceName);
                String apiVersion = propertiesNode.get("apiVersion").get("default").toString().replaceAll(Pattern.quote("\""), "");
                String apiGroup = "";
                if (apiVersion.contains("/")) {
                    apiGroup = apiVersion.substring(0, apiVersion.lastIndexOf("/"));
                    apiVersion = apiVersion.substring(apiGroup.length() + 1);
                }
                resourceClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceClass.annotate(ApiGroup.class).param("value", apiGroup);
                resourceListClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceListClass.annotate(ApiGroup.class).param("value", apiGroup);
                if (resourceClass.getPackage().name().startsWith("io.fabric8.kubernetes")) {
                    JAnnotationArrayMember arrayMember = resourceClass.annotate(VelocityTransformations.class).paramArray("value");
                    arrayMember.annotate(VelocityTransformation.class).param("value", "/manifest.vm").param("outputPath", "kubernetes.properties").param("gather", true);
                } else if (resourceClass.getPackage().name().startsWith("io.fabric8.openshift")) {
                    JAnnotationArrayMember arrayMember = resourceClass.annotate(VelocityTransformations.class).paramArray("value");
                    arrayMember.annotate(VelocityTransformation.class).param("value", "/manifest.vm").param("outputPath", "openshift.properties").param("gather", true);
                }
                this.pendingLists.remove(resourceName);
                this.pendingResources.remove(resourceName);
            }
        }
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param("value", (Enum)JsonInclude.Include.NON_EMPTY);
        }
    }

    private int getObjectNameMaxLength(JDefinedClass clazz) {
        String kind = clazz.name();
        if (kind.equals("Namespace") || kind.equals("Project") || kind.equals("Service")) {
            return 63;
        }
        return 253;
    }

    private String getObjectNamePattern(JDefinedClass clazz) {
        String kind = clazz.name();
        if (kind.equals("Service")) {
            return "[a-z]([-a-z0-9]*[a-z0-9])?";
        }
        if (kind.equals("Namespace") || kind.equals("Project")) {
            return "[a-z0-9]([-a-z0-9]*[a-z0-9])?";
        }
        return "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    }

    private void annotateMetatadataValidator(JDefinedClass clazz) {
        if (clazz.name().equals("PodTemplateSpec")) {
            return;
        }
        for (Map.Entry f : clazz.fields().entrySet()) {
            if (!((String)f.getKey()).equals("metadata") || !((JFieldVar)f.getValue()).type().name().equals("ObjectMeta")) continue;
            try {
                JAnnotationUse annotation = ((JFieldVar)f.getValue()).annotate((JClass)new JCodeModel()._class("io.fabric8.kubernetes.api.model.validators.CheckObjectMeta"));
                if (this.isMinimal(clazz)) {
                    annotation.param("minimal", true);
                } else {
                    annotation.param("regexp", "^" + this.getObjectNamePattern(clazz) + "$").param("max", this.getObjectNameMaxLength(clazz));
                }
            }
            catch (JClassAlreadyExistsException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void envNameValidator(JDefinedClass clazz) {
        for (Map.Entry f : clazz.fields().entrySet()) {
            if (!((String)f.getKey()).equals("name") || !((JFieldVar)f.getValue()).type().name().equals("String") || !clazz.name().equals("EnvVar")) continue;
            for (JAnnotationUse annotation : ((JFieldVar)f.getValue()).annotations()) {
                if (!annotation.getAnnotationClass().name().equals("Pattern")) continue;
                annotation.param("regexp", "^[-._a-zA-Z][-._a-zA-Z0-9]*$");
            }
            return;
        }
    }

    private boolean isMinimal(JDefinedClass clazz) {
        String kind = clazz.name();
        return kind.equals("Group") || kind.equals("User") || kind.equals("Identity") || kind.equals("UserIdentityMapping") || kind.equals("ClusterNetwork") || kind.equals("HostSubnet") || kind.equals("NetNamespace") || kind.equals("Image") || kind.equals("ImageStream") || kind.equals("ImageStreamMapping") || kind.equals("ImageStreamTag") || kind.equals("ImageStreamImport") || kind.equals("Policy") || kind.equals("PolicyBinding") || kind.equals("Role") || kind.equals("RoleBinding") || kind.equals("OAuthAccessToken") || kind.equals("OAuthAuthorizeToken") || kind.equals("OAuthClientAuthorization");
    }
}

