package io.fabric8.kubernetes.api.model.apiextensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>> extends Fluent<A>{


    public A addToConversionReviewVersions(int index,String item);
    public A setToConversionReviewVersions(int index,String item);
    public A addToConversionReviewVersions(String... items);
    public A addAllToConversionReviewVersions(Collection<String> items);
    public A removeFromConversionReviewVersions(String... items);
    public A removeAllFromConversionReviewVersions(Collection<String> items);
    public List<String> getConversionReviewVersions();
    public String getConversionReviewVersion(int index);
    public String getFirstConversionReviewVersion();
    public String getLastConversionReviewVersion();
    public String getMatchingConversionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingConversionReviewVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withConversionReviewVersions(List<String> conversionReviewVersions);
    public A withConversionReviewVersions(String... conversionReviewVersions);
    public Boolean hasConversionReviewVersions();
    public A addNewConversionReviewVersion(String arg1);
    public A addNewConversionReviewVersion(StringBuilder arg1);
    public A addNewConversionReviewVersion(StringBuffer arg1);
    public String getStrategy();
    public A withStrategy(String strategy);
    public Boolean hasStrategy();
    public A withNewStrategy(String arg1);
    public A withNewStrategy(StringBuilder arg1);
    public A withNewStrategy(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildWebhookClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public WebhookClientConfig getWebhookClientConfig();
    public WebhookClientConfig buildWebhookClientConfig();
    public A withWebhookClientConfig(WebhookClientConfig webhookClientConfig);
    public Boolean hasWebhookClientConfig();
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig();
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(WebhookClientConfig item);
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig();
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig();
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(WebhookClientConfig item);

    public interface WebhookClientConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WebhookClientConfigFluent<CustomResourceConversionFluent.WebhookClientConfigNested<N>>{

        
    public N and();    public N endWebhookClientConfig();
}


}
