package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceColumnDefinitionBuilder extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> {

    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceColumnDefinitionBuilder() { 
        this(true);
    }


    public CustomResourceColumnDefinitionBuilder(Boolean validationEnabled) { 
        this(new CustomResourceColumnDefinition(), validationEnabled);
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<?> fluent) { 
        this(fluent, true);
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CustomResourceColumnDefinition(), validationEnabled);
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition instance) { 
        this(fluent, instance, true);
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withJSONPath(instance.getJSONPath()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withFormat(instance.getFormat()); 
        fluent.withName(instance.getName()); 
        fluent.withPriority(instance.getPriority()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition instance) { 
        this(instance,true);
    }


    public CustomResourceColumnDefinitionBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withJSONPath(instance.getJSONPath()); 
        this.withDescription(instance.getDescription()); 
        this.withFormat(instance.getFormat()); 
        this.withName(instance.getName()); 
        this.withPriority(instance.getPriority()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition build() {
        CustomResourceColumnDefinition buildable = new CustomResourceColumnDefinition(fluent.getJSONPath(),fluent.getDescription(),fluent.getFormat(),fluent.getName(),fluent.getPriority(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceColumnDefinitionBuilder that = (CustomResourceColumnDefinitionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
