package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WebhookConversionBuilder extends WebhookConversionFluentImpl<WebhookConversionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<WebhookConversion,WebhookConversionBuilder> {

    WebhookConversionFluent<?> fluent;
    Boolean validationEnabled;

    public WebhookConversionBuilder() {
        this(true);
    }

    public WebhookConversionBuilder(Boolean validationEnabled) {
        this(new WebhookConversion(), validationEnabled);
    }

    public WebhookConversionBuilder(WebhookConversionFluent<?> fluent) {
        this(fluent, true);
    }

    public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new WebhookConversion(), validationEnabled);
    }

    public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,WebhookConversion instance) {
        this(fluent, instance, true);
    }

    public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,WebhookConversion instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientConfig(instance.getClientConfig()); 
        fluent.withConversionReviewVersions(instance.getConversionReviewVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public WebhookConversionBuilder(WebhookConversion instance) {
        this(instance,true);
    }

    public WebhookConversionBuilder(WebhookConversion instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientConfig(instance.getClientConfig()); 
        this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public WebhookConversion build() {
        WebhookConversion buildable = new WebhookConversion(fluent.getClientConfig(),fluent.getConversionReviewVersions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WebhookConversionBuilder that = (WebhookConversionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
