package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CustomResourceConversionFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent<A> {

    private List<String> conversionReviewVersions = new ArrayList<String>();
    private String strategy;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder webhookClientConfig;

    public CustomResourceConversionFluentImpl() {
    }

    public CustomResourceConversionFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion instance) {
        this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
        this.withStrategy(instance.getStrategy()); 
        this.withWebhookClientConfig(instance.getWebhookClientConfig()); 
    }

    public A addToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.set(index, item); return (A)this;
    }

    public A addToConversionReviewVersions(String... items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromConversionReviewVersions(String... items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (this.conversionReviewVersions != null) { _visitables.get("conversionReviewVersions").removeAll(this.conversionReviewVersions);}
        if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList<String>(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
    }

    public A withConversionReviewVersions(String... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear();}
        if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasConversionReviewVersions() {
        return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
    }

    public A addNewConversionReviewVersion(StringBuilder arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(int[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(char[] arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(StringBuffer arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2));
    }

    public A addNewConversionReviewVersion(byte[] arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(char[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewConversionReviewVersion(String arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy=strategy; return (A) this;
    }

    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    public A withNewStrategy(StringBuilder arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(int[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(char[] arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(StringBuffer arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(byte[] arg1,int arg2) {
        return (A)withStrategy(new String(arg1, arg2));
    }

    public A withNewStrategy(byte[] arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(char[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(byte[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStrategy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStrategy(String arg1) {
        return (A)withStrategy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildWebhookClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig!=null?this.webhookClientConfig.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig buildWebhookClientConfig() {
        return this.webhookClientConfig!=null?this.webhookClientConfig.build():null;
    }

    public A withWebhookClientConfig(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig webhookClientConfig) {
        _visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
        if (webhookClientConfig!=null){ this.webhookClientConfig= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(webhookClientConfig); _visitables.get("webhookClientConfig").add(this.webhookClientConfig);} return (A) this;
    }

    public Boolean hasWebhookClientConfig() {
        return this.webhookClientConfig != null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig() {
        return new WebhookClientConfigNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
        return new WebhookClientConfigNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig() {
        return withNewWebhookClientConfigLike(getWebhookClientConfig());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
        return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
        return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl) o;
        if (conversionReviewVersions != null ? !conversionReviewVersions.equals(that.conversionReviewVersions) :that.conversionReviewVersions != null) return false;
        if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
        if (webhookClientConfig != null ? !webhookClientConfig.equals(that.webhookClientConfig) :that.webhookClientConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conversionReviewVersions,  strategy,  webhookClientConfig,  super.hashCode());
    }

    public class WebhookClientConfigNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent.WebhookClientConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder;

            WebhookClientConfigNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(this, item);
                        
            }

            WebhookClientConfigNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceConversionFluentImpl.this.withWebhookClientConfig(builder.build());
            }

            public N endWebhookClientConfig() {
                return and();
            }
    }


}
