package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceDefinitionListBuilder extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder> {

    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceDefinitionListBuilder() {
        this(true);
    }

    public CustomResourceDefinitionListBuilder(Boolean validationEnabled) {
        this(new CustomResourceDefinitionList(), validationEnabled);
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CustomResourceDefinitionList(), validationEnabled);
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList instance) {
        this(fluent, instance, true);
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList instance) {
        this(instance,true);
    }

    public CustomResourceDefinitionListBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList build() {
        CustomResourceDefinitionList buildable = new CustomResourceDefinitionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceDefinitionListBuilder that = (CustomResourceDefinitionListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
