package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class CustomResourceDefinitionVersionFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent<A> {

    private List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> additionalPrinterColumns =  new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();
    private Boolean deprecated;
    private String deprecationWarning;
    private String name;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder schema;
    private Boolean served;
    private Boolean storage;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder subresources;

    public CustomResourceDefinitionVersionFluentImpl() {
    }

    public CustomResourceDefinitionVersionFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion instance) {
        this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
        this.withDeprecated(instance.getDeprecated()); 
        this.withDeprecationWarning(instance.getDeprecationWarning()); 
        this.withName(instance.getName()); 
        this.withSchema(instance.getSchema()); 
        this.withServed(instance.getServed()); 
        this.withStorage(instance.getStorage()); 
        this.withSubresources(instance.getSubresources()); 
    }

    public A addToAdditionalPrinterColumns(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(index >= 0 ? index : _visitables.get("additionalPrinterColumns").size(), builder);this.additionalPrinterColumns.add(index >= 0 ? index : additionalPrinterColumns.size(), builder); return (A)this;
    }

    public A setToAdditionalPrinterColumns(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("additionalPrinterColumns").size()) { _visitables.get("additionalPrinterColumns").add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder);}
        if (index < 0 || index >= additionalPrinterColumns.size()) { additionalPrinterColumns.add(builder); } else { additionalPrinterColumns.set(index, builder);}
         return (A)this;
    }

    public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A addAllToAdditionalPrinterColumns(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeAllFromAdditionalPrinterColumns(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAdditionalPrinterColumns(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        if (additionalPrinterColumns == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
        final List visitables = _visitables.get("additionalPrinterColumns");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAdditionalPrinterColumns instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
        return this.additionalPrinterColumns.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAdditionalPrinterColumn(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalPrinterColumns(List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) { _visitables.get("additionalPrinterColumns").removeAll(this.additionalPrinterColumns);}
        if (additionalPrinterColumns != null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>(); for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : additionalPrinterColumns){this.addToAdditionalPrinterColumns(item);}} else { this.additionalPrinterColumns = null;} return (A) this;
    }

    public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.clear();}
        if (additionalPrinterColumns != null) {for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item :additionalPrinterColumns){ this.addToAdditionalPrinterColumns(item);}} return (A) this;
    }

    public Boolean hasAdditionalPrinterColumns() {
        return additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
        return new AdditionalPrinterColumnsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
        if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
        if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
        int index = additionalPrinterColumns.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<additionalPrinterColumns.size();i++) { 
        if (predicate.test(additionalPrinterColumns.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public A withDeprecated(Boolean deprecated) {
        this.deprecated=deprecated; return (A) this;
    }

    public Boolean hasDeprecated() {
        return this.deprecated != null;
    }

    public A withNewDeprecated(String arg1) {
        return (A)withDeprecated(new Boolean(arg1));
    }

    public A withNewDeprecated(boolean arg1) {
        return (A)withDeprecated(new Boolean(arg1));
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public A withDeprecationWarning(String deprecationWarning) {
        this.deprecationWarning=deprecationWarning; return (A) this;
    }

    public Boolean hasDeprecationWarning() {
        return this.deprecationWarning != null;
    }

    public A withNewDeprecationWarning(StringBuilder arg1) {
        return (A)withDeprecationWarning(new String(arg1));
    }

    public A withNewDeprecationWarning(int[] arg1,int arg2,int arg3) {
        return (A)withDeprecationWarning(new String(arg1, arg2, arg3));
    }

    public A withNewDeprecationWarning(char[] arg1) {
        return (A)withDeprecationWarning(new String(arg1));
    }

    public A withNewDeprecationWarning(StringBuffer arg1) {
        return (A)withDeprecationWarning(new String(arg1));
    }

    public A withNewDeprecationWarning(byte[] arg1,int arg2) {
        return (A)withDeprecationWarning(new String(arg1, arg2));
    }

    public A withNewDeprecationWarning(byte[] arg1) {
        return (A)withDeprecationWarning(new String(arg1));
    }

    public A withNewDeprecationWarning(char[] arg1,int arg2,int arg3) {
        return (A)withDeprecationWarning(new String(arg1, arg2, arg3));
    }

    public A withNewDeprecationWarning(byte[] arg1,int arg2,int arg3) {
        return (A)withDeprecationWarning(new String(arg1, arg2, arg3));
    }

    public A withNewDeprecationWarning(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDeprecationWarning(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDeprecationWarning(String arg1) {
        return (A)withDeprecationWarning(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSchema instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation getSchema() {
        return this.schema!=null?this.schema.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation buildSchema() {
        return this.schema!=null?this.schema.build():null;
    }

    public A withSchema(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation schema) {
        _visitables.get("schema").remove(this.schema);
        if (schema!=null){ this.schema= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(schema); _visitables.get("schema").add(this.schema);} return (A) this;
    }

    public Boolean hasSchema() {
        return this.schema != null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<A> withNewSchema() {
        return new SchemaNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<A> withNewSchemaLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
        return new SchemaNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<A> editSchema() {
        return withNewSchemaLike(getSchema());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<A> editOrNewSchema() {
        return withNewSchemaLike(getSchema() != null ? getSchema(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<A> editOrNewSchemaLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
        return withNewSchemaLike(getSchema() != null ? getSchema(): item);
    }

    public Boolean getServed() {
        return this.served;
    }

    public A withServed(Boolean served) {
        this.served=served; return (A) this;
    }

    public Boolean hasServed() {
        return this.served != null;
    }

    public A withNewServed(String arg1) {
        return (A)withServed(new Boolean(arg1));
    }

    public A withNewServed(boolean arg1) {
        return (A)withServed(new Boolean(arg1));
    }

    public Boolean getStorage() {
        return this.storage;
    }

    public A withStorage(Boolean storage) {
        this.storage=storage; return (A) this;
    }

    public Boolean hasStorage() {
        return this.storage != null;
    }

    public A withNewStorage(String arg1) {
        return (A)withStorage(new Boolean(arg1));
    }

    public A withNewStorage(boolean arg1) {
        return (A)withStorage(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSubresources instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources getSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources buildSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public A withSubresources(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources subresources) {
        _visitables.get("subresources").remove(this.subresources);
        if (subresources!=null){ this.subresources= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(subresources); _visitables.get("subresources").add(this.subresources);} return (A) this;
    }

    public Boolean hasSubresources() {
        return this.subresources != null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<A> withNewSubresources() {
        return new SubresourcesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<A> withNewSubresourcesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
        return new SubresourcesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<A> editSubresources() {
        return withNewSubresourcesLike(getSubresources());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<A> editOrNewSubresources() {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<A> editOrNewSubresourcesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceDefinitionVersionFluentImpl that = (CustomResourceDefinitionVersionFluentImpl) o;
        if (additionalPrinterColumns != null ? !additionalPrinterColumns.equals(that.additionalPrinterColumns) :that.additionalPrinterColumns != null) return false;
        if (deprecated != null ? !deprecated.equals(that.deprecated) :that.deprecated != null) return false;
        if (deprecationWarning != null ? !deprecationWarning.equals(that.deprecationWarning) :that.deprecationWarning != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (schema != null ? !schema.equals(that.schema) :that.schema != null) return false;
        if (served != null ? !served.equals(that.served) :that.served != null) return false;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (subresources != null ? !subresources.equals(that.subresources) :that.subresources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalPrinterColumns,  deprecated,  deprecationWarning,  name,  schema,  served,  storage,  subresources,  super.hashCode());
    }

    public class AdditionalPrinterColumnsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.AdditionalPrinterColumnsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder;
        private final int index;

            AdditionalPrinterColumnsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this, item);
                        
            }

            AdditionalPrinterColumnsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceDefinitionVersionFluentImpl.this.setToAdditionalPrinterColumns(index,builder.build());
            }

            public N endAdditionalPrinterColumn() {
                return and();
            }
    }


    public class SchemaNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SchemaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder;

            SchemaNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this, item);
                        
            }

            SchemaNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceDefinitionVersionFluentImpl.this.withSchema(builder.build());
            }

            public N endSchema() {
                return and();
            }
    }


    public class SubresourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent.SubresourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder;

            SubresourcesNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this, item);
                        
            }

            SubresourcesNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceDefinitionVersionFluentImpl.this.withSubresources(builder.build());
            }

            public N endSubresources() {
                return and();
            }
    }


}
