package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceColumnDefinitionBuilder extends CustomResourceColumnDefinitionFluentImpl<CustomResourceColumnDefinitionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CustomResourceColumnDefinition,CustomResourceColumnDefinitionBuilder> {

    CustomResourceColumnDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceColumnDefinitionBuilder() {
        this(true);
    }

    public CustomResourceColumnDefinitionBuilder(Boolean validationEnabled) {
        this(new CustomResourceColumnDefinition(), validationEnabled);
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CustomResourceColumnDefinition(), validationEnabled);
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,CustomResourceColumnDefinition instance) {
        this(fluent, instance, true);
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,CustomResourceColumnDefinition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDescription(instance.getDescription()); 
        fluent.withFormat(instance.getFormat()); 
        fluent.withJsonPath(instance.getJsonPath()); 
        fluent.withName(instance.getName()); 
        fluent.withPriority(instance.getPriority()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinition instance) {
        this(instance,true);
    }

    public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDescription(instance.getDescription()); 
        this.withFormat(instance.getFormat()); 
        this.withJsonPath(instance.getJsonPath()); 
        this.withName(instance.getName()); 
        this.withPriority(instance.getPriority()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceColumnDefinition build() {
        CustomResourceColumnDefinition buildable = new CustomResourceColumnDefinition(fluent.getDescription(),fluent.getFormat(),fluent.getJsonPath(),fluent.getName(),fluent.getPriority(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceColumnDefinitionBuilder that = (CustomResourceColumnDefinitionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
