package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CustomResourceDefinitionNamesFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluent<A> {

    private List<String> categories = new ArrayList<String>();
    private String kind;
    private String listKind;
    private String plural;
    private List<String> shortNames = new ArrayList<String>();
    private String singular;

    public CustomResourceDefinitionNamesFluentImpl() {
    }

    public CustomResourceDefinitionNamesFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames instance) {
        this.withCategories(instance.getCategories()); 
        this.withKind(instance.getKind()); 
        this.withListKind(instance.getListKind()); 
        this.withPlural(instance.getPlural()); 
        this.withShortNames(instance.getShortNames()); 
        this.withSingular(instance.getSingular()); 
    }

    public A addToCategories(int index,String item) {
        if (this.categories == null) {this.categories = new ArrayList<String>();}
        this.categories.add(index, item);
        return (A)this;
    }

    public A setToCategories(int index,String item) {
        if (this.categories == null) {this.categories = new ArrayList<String>();}
        this.categories.set(index, item); return (A)this;
    }

    public A addToCategories(String... items) {
        if (this.categories == null) {this.categories = new ArrayList<String>();}
        for (String item : items) {this.categories.add(item);} return (A)this;
    }

    public A addAllToCategories(Collection<String> items) {
        if (this.categories == null) {this.categories = new ArrayList<String>();}
        for (String item : items) {this.categories.add(item);} return (A)this;
    }

    public A removeFromCategories(String... items) {
        for (String item : items) {if (this.categories!= null){ this.categories.remove(item);}} return (A)this;
    }

    public A removeAllFromCategories(Collection<String> items) {
        for (String item : items) {if (this.categories!= null){ this.categories.remove(item);}} return (A)this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getCategory(int index) {
        return this.categories.get(index);
    }

    public String getFirstCategory() {
        return this.categories.get(0);
    }

    public String getLastCategory() {
        return this.categories.get(categories.size() - 1);
    }

    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item: categories) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCategory(Predicate<String> predicate) {
        for (String item: categories) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCategories(List<String> categories) {
        if (this.categories != null) { _visitables.get("categories").removeAll(this.categories);}
        if (categories != null) {this.categories = new ArrayList<String>(); for (String item : categories){this.addToCategories(item);}} else { this.categories = null;} return (A) this;
    }

    public A withCategories(String... categories) {
        if (this.categories != null) {this.categories.clear();}
        if (categories != null) {for (String item :categories){ this.addToCategories(item);}} return (A) this;
    }

    public Boolean hasCategories() {
        return categories != null && !categories.isEmpty();
    }

    public A addNewCategory(StringBuilder arg1) {
        return (A)addToCategories(new String(arg1));
    }

    public A addNewCategory(int[] arg1,int arg2,int arg3) {
        return (A)addToCategories(new String(arg1, arg2, arg3));
    }

    public A addNewCategory(char[] arg1) {
        return (A)addToCategories(new String(arg1));
    }

    public A addNewCategory(StringBuffer arg1) {
        return (A)addToCategories(new String(arg1));
    }

    public A addNewCategory(byte[] arg1,int arg2) {
        return (A)addToCategories(new String(arg1, arg2));
    }

    public A addNewCategory(byte[] arg1) {
        return (A)addToCategories(new String(arg1));
    }

    public A addNewCategory(char[] arg1,int arg2,int arg3) {
        return (A)addToCategories(new String(arg1, arg2, arg3));
    }

    public A addNewCategory(byte[] arg1,int arg2,int arg3) {
        return (A)addToCategories(new String(arg1, arg2, arg3));
    }

    public A addNewCategory(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToCategories(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewCategory(String arg1) {
        return (A)addToCategories(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getListKind() {
        return this.listKind;
    }

    public A withListKind(String listKind) {
        this.listKind=listKind; return (A) this;
    }

    public Boolean hasListKind() {
        return this.listKind != null;
    }

    public A withNewListKind(StringBuilder arg1) {
        return (A)withListKind(new String(arg1));
    }

    public A withNewListKind(int[] arg1,int arg2,int arg3) {
        return (A)withListKind(new String(arg1, arg2, arg3));
    }

    public A withNewListKind(char[] arg1) {
        return (A)withListKind(new String(arg1));
    }

    public A withNewListKind(StringBuffer arg1) {
        return (A)withListKind(new String(arg1));
    }

    public A withNewListKind(byte[] arg1,int arg2) {
        return (A)withListKind(new String(arg1, arg2));
    }

    public A withNewListKind(byte[] arg1) {
        return (A)withListKind(new String(arg1));
    }

    public A withNewListKind(char[] arg1,int arg2,int arg3) {
        return (A)withListKind(new String(arg1, arg2, arg3));
    }

    public A withNewListKind(byte[] arg1,int arg2,int arg3) {
        return (A)withListKind(new String(arg1, arg2, arg3));
    }

    public A withNewListKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withListKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewListKind(String arg1) {
        return (A)withListKind(new String(arg1));
    }

    public String getPlural() {
        return this.plural;
    }

    public A withPlural(String plural) {
        this.plural=plural; return (A) this;
    }

    public Boolean hasPlural() {
        return this.plural != null;
    }

    public A withNewPlural(StringBuilder arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(int[] arg1,int arg2,int arg3) {
        return (A)withPlural(new String(arg1, arg2, arg3));
    }

    public A withNewPlural(char[] arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(StringBuffer arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(byte[] arg1,int arg2) {
        return (A)withPlural(new String(arg1, arg2));
    }

    public A withNewPlural(byte[] arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A withNewPlural(char[] arg1,int arg2,int arg3) {
        return (A)withPlural(new String(arg1, arg2, arg3));
    }

    public A withNewPlural(byte[] arg1,int arg2,int arg3) {
        return (A)withPlural(new String(arg1, arg2, arg3));
    }

    public A withNewPlural(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPlural(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPlural(String arg1) {
        return (A)withPlural(new String(arg1));
    }

    public A addToShortNames(int index,String item) {
        if (this.shortNames == null) {this.shortNames = new ArrayList<String>();}
        this.shortNames.add(index, item);
        return (A)this;
    }

    public A setToShortNames(int index,String item) {
        if (this.shortNames == null) {this.shortNames = new ArrayList<String>();}
        this.shortNames.set(index, item); return (A)this;
    }

    public A addToShortNames(String... items) {
        if (this.shortNames == null) {this.shortNames = new ArrayList<String>();}
        for (String item : items) {this.shortNames.add(item);} return (A)this;
    }

    public A addAllToShortNames(Collection<String> items) {
        if (this.shortNames == null) {this.shortNames = new ArrayList<String>();}
        for (String item : items) {this.shortNames.add(item);} return (A)this;
    }

    public A removeFromShortNames(String... items) {
        for (String item : items) {if (this.shortNames!= null){ this.shortNames.remove(item);}} return (A)this;
    }

    public A removeAllFromShortNames(Collection<String> items) {
        for (String item : items) {if (this.shortNames!= null){ this.shortNames.remove(item);}} return (A)this;
    }

    public List<String> getShortNames() {
        return this.shortNames;
    }

    public String getShortName(int index) {
        return this.shortNames.get(index);
    }

    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    public String getLastShortName() {
        return this.shortNames.get(shortNames.size() - 1);
    }

    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item: shortNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingShortName(Predicate<String> predicate) {
        for (String item: shortNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withShortNames(List<String> shortNames) {
        if (this.shortNames != null) { _visitables.get("shortNames").removeAll(this.shortNames);}
        if (shortNames != null) {this.shortNames = new ArrayList<String>(); for (String item : shortNames){this.addToShortNames(item);}} else { this.shortNames = null;} return (A) this;
    }

    public A withShortNames(String... shortNames) {
        if (this.shortNames != null) {this.shortNames.clear();}
        if (shortNames != null) {for (String item :shortNames){ this.addToShortNames(item);}} return (A) this;
    }

    public Boolean hasShortNames() {
        return shortNames != null && !shortNames.isEmpty();
    }

    public A addNewShortName(StringBuilder arg1) {
        return (A)addToShortNames(new String(arg1));
    }

    public A addNewShortName(int[] arg1,int arg2,int arg3) {
        return (A)addToShortNames(new String(arg1, arg2, arg3));
    }

    public A addNewShortName(char[] arg1) {
        return (A)addToShortNames(new String(arg1));
    }

    public A addNewShortName(StringBuffer arg1) {
        return (A)addToShortNames(new String(arg1));
    }

    public A addNewShortName(byte[] arg1,int arg2) {
        return (A)addToShortNames(new String(arg1, arg2));
    }

    public A addNewShortName(byte[] arg1) {
        return (A)addToShortNames(new String(arg1));
    }

    public A addNewShortName(char[] arg1,int arg2,int arg3) {
        return (A)addToShortNames(new String(arg1, arg2, arg3));
    }

    public A addNewShortName(byte[] arg1,int arg2,int arg3) {
        return (A)addToShortNames(new String(arg1, arg2, arg3));
    }

    public A addNewShortName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToShortNames(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewShortName(String arg1) {
        return (A)addToShortNames(new String(arg1));
    }

    public String getSingular() {
        return this.singular;
    }

    public A withSingular(String singular) {
        this.singular=singular; return (A) this;
    }

    public Boolean hasSingular() {
        return this.singular != null;
    }

    public A withNewSingular(StringBuilder arg1) {
        return (A)withSingular(new String(arg1));
    }

    public A withNewSingular(int[] arg1,int arg2,int arg3) {
        return (A)withSingular(new String(arg1, arg2, arg3));
    }

    public A withNewSingular(char[] arg1) {
        return (A)withSingular(new String(arg1));
    }

    public A withNewSingular(StringBuffer arg1) {
        return (A)withSingular(new String(arg1));
    }

    public A withNewSingular(byte[] arg1,int arg2) {
        return (A)withSingular(new String(arg1, arg2));
    }

    public A withNewSingular(byte[] arg1) {
        return (A)withSingular(new String(arg1));
    }

    public A withNewSingular(char[] arg1,int arg2,int arg3) {
        return (A)withSingular(new String(arg1, arg2, arg3));
    }

    public A withNewSingular(byte[] arg1,int arg2,int arg3) {
        return (A)withSingular(new String(arg1, arg2, arg3));
    }

    public A withNewSingular(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSingular(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSingular(String arg1) {
        return (A)withSingular(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceDefinitionNamesFluentImpl that = (CustomResourceDefinitionNamesFluentImpl) o;
        if (categories != null ? !categories.equals(that.categories) :that.categories != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (listKind != null ? !listKind.equals(that.listKind) :that.listKind != null) return false;
        if (plural != null ? !plural.equals(that.plural) :that.plural != null) return false;
        if (shortNames != null ? !shortNames.equals(that.shortNames) :that.shortNames != null) return false;
        if (singular != null ? !singular.equals(that.singular) :that.singular != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(categories,  kind,  listKind,  plural,  shortNames,  singular,  super.hashCode());
    }

}
