/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WebhookConversionFluentImpl<A extends WebhookConversionFluent<A>>
extends BaseFluent<A>
implements WebhookConversionFluent<A> {
    private WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public WebhookConversionFluentImpl() {
    }

    public WebhookConversionFluentImpl(WebhookConversion instance) {
        this.withClientConfig(instance.getClientConfig());
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public WebhookClientConfig getClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public A withClientConfig(WebhookClientConfig clientConfig) {
        this._visitables.get((Object)"clientConfig").remove(this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new WebhookClientConfigBuilder(clientConfig);
            this._visitables.get((Object)"clientConfig").add(this.clientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    @Override
    public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    @Override
    public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    @Override
    public WebhookConversionFluent.ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig());
    }

    @Override
    public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : new WebhookClientConfigBuilder().build());
    }

    @Override
    public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : item);
    }

    @Override
    public A addToConversionReviewVersions(Integer index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConversionReviewVersions(Integer index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConversionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    @Override
    public String getConversionReviewVersion(Integer index) {
        return this.conversionReviewVersions.get(index);
    }

    @Override
    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    @Override
    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookConversionFluentImpl that = (WebhookConversionFluentImpl)o;
        if (this.clientConfig != null ? !this.clientConfig.equals(that.clientConfig) : that.clientConfig != null) {
            return false;
        }
        if (this.conversionReviewVersions != null ? !this.conversionReviewVersions.equals(that.conversionReviewVersions) : that.conversionReviewVersions != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfig, this.conversionReviewVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append(this.clientConfig + ",");
        }
        if (this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty()) {
            sb.append("conversionReviewVersions:");
            sb.append(this.conversionReviewVersions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientConfigNestedImpl<N>
    extends WebhookClientConfigFluentImpl<WebhookConversionFluent.ClientConfigNested<N>>
    implements WebhookConversionFluent.ClientConfigNested<N>,
    Nested<N> {
        WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebhookConversionFluentImpl.this.withClientConfig(this.builder.build());
        }

        @Override
        public N endClientConfig() {
            return this.and();
        }
    }
}

