package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomResourceConversionBuilder extends CustomResourceConversionFluent<CustomResourceConversionBuilder> implements VisitableBuilder<CustomResourceConversion,CustomResourceConversionBuilder>{
  public CustomResourceConversionBuilder() {
    this(new CustomResourceConversion());
  }
  
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent) {
    this(fluent, new CustomResourceConversion());
  }
  
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent,CustomResourceConversion instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomResourceConversionBuilder(CustomResourceConversion instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomResourceConversionFluent<?> fluent;
  
  public CustomResourceConversion build() {
    CustomResourceConversion buildable = new CustomResourceConversion(fluent.getStrategy(),fluent.buildWebhook());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}