package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceSubresourceStatusBuilder extends CustomResourceSubresourceStatusFluentImpl<CustomResourceSubresourceStatusBuilder> implements VisitableBuilder<CustomResourceSubresourceStatus,CustomResourceSubresourceStatusBuilder>{
  public CustomResourceSubresourceStatusBuilder() {
    this(false);
  }
  public CustomResourceSubresourceStatusBuilder(Boolean validationEnabled) {
    this(new CustomResourceSubresourceStatus(), validationEnabled);
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceSubresourceStatus(), validationEnabled);
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatusFluent<?> fluent,CustomResourceSubresourceStatus instance) {
    this(fluent, instance, false);
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatusFluent<?> fluent,CustomResourceSubresourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatus instance) {
    this(instance,false);
  }
  public CustomResourceSubresourceStatusBuilder(CustomResourceSubresourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomResourceSubresourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceSubresourceStatus build() {
    CustomResourceSubresourceStatus buildable = new CustomResourceSubresourceStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}