package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConversionRequestFluentImpl<A extends ConversionRequestFluent<A>> extends BaseFluent<A> implements ConversionRequestFluent<A>{
  public ConversionRequestFluentImpl() {
  }
  public ConversionRequestFluentImpl(ConversionRequest instance) {
    this.withDesiredAPIVersion(instance.getDesiredAPIVersion()); 
    this.withObjects(instance.getObjects()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String desiredAPIVersion;
  private ArrayList<VisitableBuilder<? extends KubernetesResource,?>> objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();
  private String uid;
  private Map<String,Object> additionalProperties;
  public String getDesiredAPIVersion() {
    return this.desiredAPIVersion;
  }
  public A withDesiredAPIVersion(String desiredAPIVersion) {
    this.desiredAPIVersion=desiredAPIVersion; return (A) this;
  }
  public Boolean hasDesiredAPIVersion() {
    return this.desiredAPIVersion != null;
  }
  public A addToObjects(VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
  }
  public A addToObjects(Integer index,VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    _visitables.get("objects").add(index, builder);this.objects.add(index, builder); return (A)this;
  }
  public A addToObjects(Integer index,KubernetesResource item) {
    if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){addToLabelSelectorObjects(index, (LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects(index, (CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){addToServiceReferenceObjects(index, (ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects(index, (JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects(index, (CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){addToPodTemplateSpecObjects(index, (PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects(index, (CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects(index, (CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){addToExternalDocumentationObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects(index, (CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects(index, (CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){addToResourceRequirementsObjects(index, (ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){addToCustomResourceValidationObjects(index, (CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){addToJSONSchemaPropsObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){addToConversionResponseObjects(index, (ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){addToRawExtensionObjects(index, (RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){addToValidationRuleObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects(index, (JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){addToObjectMetaObjects(index, (ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){addToCustomResourceSubresourcesObjects(index, (CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){addToConversionRequestObjects(index, (ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){addToJSONSchemaPropsObjects(index, (JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){addToWebhookClientConfigObjects(index, (WebhookClientConfig)item);}
 else if (item instanceof Container){addToContainerObjects(index, (Container)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects(index, (GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){addToWebhookClientConfigObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects(index, (CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){addToWebhookConversionObjects(index, (WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){addToLocalObjectReferenceObjects(index, (LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){addToExternalDocumentationObjects(index, (ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){addToCustomResourceSubresourcesObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects(index, (CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){addToCustomResourceConversionObjects(index, (CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){addToValidationRuleObjects(index, (ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionObjects(index, (CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){addToServiceReferenceObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects(index, (CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){addToObjectReferenceObjects(index, (ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects(index, (JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){addToConversionReviewObjects(index, (ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){addToCustomResourceValidationObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){addToCustomResourceConversionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    return (A)this;
  }
  public A setToObjects(Integer index,KubernetesResource item) {
    if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){setToJSONSchemaPropsOrArrayObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){setToLabelSelectorObjects(index, (LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){setToCustomResourceDefinitionStatusObjects(index, (CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){setToServiceReferenceObjects(index, (ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){setToCustomResourceDefinitionStatusObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){setToJSONSchemaPropsOrBoolObjects(index, (JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){setToCustomResourceDefinitionSpecObjects(index, (CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){setToCustomResourceSubresourceStatusObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){setToPodTemplateSpecObjects(index, (PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){setToCustomResourceSubresourceScaleObjects(index, (CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){setToCustomResourceDefinitionNamesObjects(index, (CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){setToExternalDocumentationObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){setToCustomResourceSubresourceScaleObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){setToCustomResourceDefinitionConditionObjects(index, (CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){setToCustomResourceSubresourceStatusObjects(index, (CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){setToResourceRequirementsObjects(index, (ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){setToCustomResourceValidationObjects(index, (CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){setToCustomResourceDefinitionVersionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){setToJSONSchemaPropsObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){setToConversionResponseObjects(index, (ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){setToJSONSchemaPropsOrBoolObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){setToRawExtensionObjects(index, (RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){setToCustomResourceDefinitionNamesObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){setToValidationRuleObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){setToJSONSchemaPropsOrStringArrayObjects(index, (JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){setToObjectMetaObjects(index, (ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){setToCustomResourceSubresourcesObjects(index, (CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){setToConversionRequestObjects(index, (ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){setToJSONSchemaPropsObjects(index, (JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){setToJSONSchemaPropsOrStringArrayObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){setToWebhookClientConfigObjects(index, (WebhookClientConfig)item);}
 else if (item instanceof Container){setToContainerObjects(index, (Container)item);}
 else if (item instanceof GenericKubernetesResource){setToGenericKubernetesResourceObjects(index, (GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){setToCustomResourceColumnDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){setToWebhookClientConfigObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){setToCustomResourceColumnDefinitionObjects(index, (CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){setToWebhookConversionObjects(index, (WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){setToLocalObjectReferenceObjects(index, (LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){setToExternalDocumentationObjects(index, (ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){setToCustomResourceSubresourcesObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){setToCustomResourceDefinitionVersionObjects(index, (CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){setToCustomResourceConversionObjects(index, (CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){setToValidationRuleObjects(index, (ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){setToCustomResourceDefinitionObjects(index, (CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){setToCustomResourceDefinitionConditionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){setToCustomResourceDefinitionListObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){setToServiceReferenceObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){setToCustomResourceDefinitionListObjects(index, (CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){setToObjectReferenceObjects(index, (ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){setToJSONSchemaPropsOrArrayObjects(index, (JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){setToConversionReviewObjects(index, (ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){setToCustomResourceValidationObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){setToCustomResourceConversionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){setToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){setToCustomResourceDefinitionSpecObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    return (A)this;
  }
  public A addToObjects(io.fabric8.kubernetes.api.model.KubernetesResource... items) {
     if (items != null && items.length > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (KubernetesResource item : items) { 
    if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){addToLabelSelectorObjects((LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects((CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){addToServiceReferenceObjects((ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects((JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects((CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){addToPodTemplateSpecObjects((PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects((CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects((CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){addToExternalDocumentationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects((CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects((CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){addToResourceRequirementsObjects((ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){addToCustomResourceValidationObjects((CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){addToJSONSchemaPropsObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){addToConversionResponseObjects((ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){addToRawExtensionObjects((RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){addToValidationRuleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects((JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){addToObjectMetaObjects((ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){addToCustomResourceSubresourcesObjects((CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){addToConversionRequestObjects((ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){addToJSONSchemaPropsObjects((JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){addToWebhookClientConfigObjects((WebhookClientConfig)item);}
 else if (item instanceof Container){addToContainerObjects((Container)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){addToWebhookClientConfigObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects((CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){addToWebhookConversionObjects((WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){addToLocalObjectReferenceObjects((LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){addToExternalDocumentationObjects((ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){addToCustomResourceSubresourcesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects((CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){addToCustomResourceConversionObjects((CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){addToValidationRuleObjects((ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionObjects((CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){addToServiceReferenceObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects((CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){addToObjectReferenceObjects((ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects((JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){addToConversionReviewObjects((ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){addToCustomResourceValidationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){addToCustomResourceConversionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    else {  VisitableBuilder<? extends KubernetesResource,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A addAllToObjects(Collection<KubernetesResource> items) {
     if (items != null && items.size() > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (KubernetesResource item : items) { 
    if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){addToLabelSelectorObjects((LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects((CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){addToServiceReferenceObjects((ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){addToCustomResourceDefinitionStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects((JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects((CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){addToPodTemplateSpecObjects((PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects((CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects((CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){addToExternalDocumentationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){addToCustomResourceSubresourceScaleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects((CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){addToCustomResourceSubresourceStatusObjects((CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){addToResourceRequirementsObjects((ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){addToCustomResourceValidationObjects((CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){addToJSONSchemaPropsObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){addToConversionResponseObjects((ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){addToJSONSchemaPropsOrBoolObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){addToRawExtensionObjects((RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){addToCustomResourceDefinitionNamesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){addToValidationRuleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects((JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){addToObjectMetaObjects((ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){addToCustomResourceSubresourcesObjects((CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){addToConversionRequestObjects((ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){addToJSONSchemaPropsObjects((JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){addToJSONSchemaPropsOrStringArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){addToWebhookClientConfigObjects((WebhookClientConfig)item);}
 else if (item instanceof Container){addToContainerObjects((Container)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){addToWebhookClientConfigObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){addToCustomResourceColumnDefinitionObjects((CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){addToWebhookConversionObjects((WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){addToLocalObjectReferenceObjects((LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){addToExternalDocumentationObjects((ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){addToCustomResourceSubresourcesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){addToCustomResourceDefinitionVersionObjects((CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){addToCustomResourceConversionObjects((CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){addToValidationRuleObjects((ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionObjects((CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){addToCustomResourceDefinitionConditionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){addToServiceReferenceObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){addToCustomResourceDefinitionListObjects((CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){addToObjectReferenceObjects((ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){addToJSONSchemaPropsOrArrayObjects((JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){addToConversionReviewObjects((ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){addToCustomResourceValidationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){addToCustomResourceConversionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){addToCustomResourceDefinitionSpecObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    else {  VisitableBuilder<? extends KubernetesResource,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A removeFromObjects(VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
  }
  public A removeFromObjects(io.fabric8.kubernetes.api.model.KubernetesResource... items) {
    for (KubernetesResource item : items) {if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){removeFromJSONSchemaPropsOrArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){removeFromLabelSelectorObjects((LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){removeFromCustomResourceDefinitionStatusObjects((CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){removeFromServiceReferenceObjects((ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){removeFromCustomResourceDefinitionStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){removeFromJSONSchemaPropsOrBoolObjects((JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){removeFromCustomResourceDefinitionSpecObjects((CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){removeFromCustomResourceSubresourceStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){removeFromPodTemplateSpecObjects((PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){removeFromCustomResourceSubresourceScaleObjects((CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){removeFromCustomResourceDefinitionNamesObjects((CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){removeFromExternalDocumentationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){removeFromCustomResourceSubresourceScaleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){removeFromCustomResourceDefinitionConditionObjects((CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){removeFromCustomResourceSubresourceStatusObjects((CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){removeFromResourceRequirementsObjects((ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){removeFromCustomResourceValidationObjects((CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){removeFromCustomResourceDefinitionVersionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){removeFromJSONSchemaPropsObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){removeFromConversionResponseObjects((ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){removeFromJSONSchemaPropsOrBoolObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){removeFromRawExtensionObjects((RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){removeFromCustomResourceDefinitionNamesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){removeFromValidationRuleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){removeFromJSONSchemaPropsOrStringArrayObjects((JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){removeFromObjectMetaObjects((ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){removeFromCustomResourceSubresourcesObjects((CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){removeFromConversionRequestObjects((ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){removeFromJSONSchemaPropsObjects((JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){removeFromJSONSchemaPropsOrStringArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){removeFromWebhookClientConfigObjects((WebhookClientConfig)item);}
 else if (item instanceof Container){removeFromContainerObjects((Container)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){removeFromCustomResourceColumnDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){removeFromWebhookClientConfigObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){removeFromCustomResourceColumnDefinitionObjects((CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){removeFromWebhookConversionObjects((WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){removeFromLocalObjectReferenceObjects((LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){removeFromExternalDocumentationObjects((ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){removeFromCustomResourceSubresourcesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){removeFromCustomResourceDefinitionVersionObjects((CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){removeFromCustomResourceConversionObjects((CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){removeFromValidationRuleObjects((ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){removeFromCustomResourceDefinitionConditionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){removeFromCustomResourceDefinitionListObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){removeFromServiceReferenceObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){removeFromCustomResourceDefinitionListObjects((CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){removeFromObjectReferenceObjects((ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){removeFromJSONSchemaPropsOrArrayObjects((JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){removeFromConversionReviewObjects((ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){removeFromCustomResourceValidationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){removeFromCustomResourceConversionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){removeFromCustomResourceDefinitionSpecObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    else {  VisitableBuilder<? extends KubernetesResource,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromObjects(Collection<KubernetesResource> items) {
    for (KubernetesResource item : items) {if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray){removeFromJSONSchemaPropsOrArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray)item);}
 else if (item instanceof LabelSelector){removeFromLabelSelectorObjects((LabelSelector)item);}
 else if (item instanceof CustomResourceDefinitionStatus){removeFromCustomResourceDefinitionStatusObjects((CustomResourceDefinitionStatus)item);}
 else if (item instanceof ServiceReference){removeFromServiceReferenceObjects((ServiceReference)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus){removeFromCustomResourceDefinitionStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus)item);}
 else if (item instanceof JSONSchemaPropsOrBool){removeFromJSONSchemaPropsOrBoolObjects((JSONSchemaPropsOrBool)item);}
 else if (item instanceof CustomResourceDefinitionSpec){removeFromCustomResourceDefinitionSpecObjects((CustomResourceDefinitionSpec)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus){removeFromCustomResourceSubresourceStatusObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus)item);}
 else if (item instanceof PodTemplateSpec){removeFromPodTemplateSpecObjects((PodTemplateSpec)item);}
 else if (item instanceof CustomResourceSubresourceScale){removeFromCustomResourceSubresourceScaleObjects((CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionNames){removeFromCustomResourceDefinitionNamesObjects((CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation){removeFromExternalDocumentationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale){removeFromCustomResourceSubresourceScaleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale)item);}
 else if (item instanceof CustomResourceDefinitionCondition){removeFromCustomResourceDefinitionConditionObjects((CustomResourceDefinitionCondition)item);}
 else if (item instanceof CustomResourceSubresourceStatus){removeFromCustomResourceSubresourceStatusObjects((CustomResourceSubresourceStatus)item);}
 else if (item instanceof ResourceRequirements){removeFromResourceRequirementsObjects((ResourceRequirements)item);}
 else if (item instanceof CustomResourceValidation){removeFromCustomResourceValidationObjects((CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion){removeFromCustomResourceDefinitionVersionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps){removeFromJSONSchemaPropsObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps)item);}
 else if (item instanceof ConversionResponse){removeFromConversionResponseObjects((ConversionResponse)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool){removeFromJSONSchemaPropsOrBoolObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool)item);}
 else if (item instanceof RawExtension){removeFromRawExtensionObjects((RawExtension)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames){removeFromCustomResourceDefinitionNamesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule){removeFromValidationRuleObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule)item);}
 else if (item instanceof JSONSchemaPropsOrStringArray){removeFromJSONSchemaPropsOrStringArrayObjects((JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof ObjectMeta){removeFromObjectMetaObjects((ObjectMeta)item);}
 else if (item instanceof CustomResourceSubresources){removeFromCustomResourceSubresourcesObjects((CustomResourceSubresources)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof ConversionRequest){removeFromConversionRequestObjects((ConversionRequest)item);}
 else if (item instanceof JSONSchemaProps){removeFromJSONSchemaPropsObjects((JSONSchemaProps)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray){removeFromJSONSchemaPropsOrStringArrayObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray)item);}
 else if (item instanceof WebhookClientConfig){removeFromWebhookClientConfigObjects((WebhookClientConfig)item);}
 else if (item instanceof Container){removeFromContainerObjects((Container)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition){removeFromCustomResourceColumnDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig){removeFromWebhookClientConfigObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig)item);}
 else if (item instanceof CustomResourceColumnDefinition){removeFromCustomResourceColumnDefinitionObjects((CustomResourceColumnDefinition)item);}
 else if (item instanceof WebhookConversion){removeFromWebhookConversionObjects((WebhookConversion)item);}
 else if (item instanceof LocalObjectReference){removeFromLocalObjectReferenceObjects((LocalObjectReference)item);}
 else if (item instanceof ExternalDocumentation){removeFromExternalDocumentationObjects((ExternalDocumentation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources){removeFromCustomResourceSubresourcesObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources)item);}
 else if (item instanceof CustomResourceDefinitionVersion){removeFromCustomResourceDefinitionVersionObjects((CustomResourceDefinitionVersion)item);}
 else if (item instanceof CustomResourceConversion){removeFromCustomResourceConversionObjects((CustomResourceConversion)item);}
 else if (item instanceof ValidationRule){removeFromValidationRuleObjects((ValidationRule)item);}
 else if (item instanceof CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition){removeFromCustomResourceDefinitionConditionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList){removeFromCustomResourceDefinitionListObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference){removeFromServiceReferenceObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference)item);}
 else if (item instanceof CustomResourceDefinitionList){removeFromCustomResourceDefinitionListObjects((CustomResourceDefinitionList)item);}
 else if (item instanceof ObjectReference){removeFromObjectReferenceObjects((ObjectReference)item);}
 else if (item instanceof JSONSchemaPropsOrArray){removeFromJSONSchemaPropsOrArrayObjects((JSONSchemaPropsOrArray)item);}
 else if (item instanceof ConversionReview){removeFromConversionReviewObjects((ConversionReview)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation){removeFromCustomResourceValidationObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion){removeFromCustomResourceConversionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec){removeFromCustomResourceDefinitionSpecObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec)item);}

    else {  VisitableBuilder<? extends KubernetesResource,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KubernetesResource> getObjects() {
    return build(objects);
  }
  public List<KubernetesResource> buildObjects() {
    return build(objects);
  }
  public KubernetesResource buildObject(Integer index) {
    return this.objects.get(index).build();
  }
  public KubernetesResource buildFirstObject() {
    return this.objects.get(0).build();
  }
  public KubernetesResource buildLastObject() {
    return this.objects.get(objects.size() - 1).build();
  }
  public KubernetesResource buildMatchingObject(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    for (VisitableBuilder<? extends KubernetesResource,?> item: objects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingObject(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    for (VisitableBuilder<? extends KubernetesResource,?> item: objects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withObjects(List<KubernetesResource> objects) {
    if (objects != null) {this.objects = new ArrayList(); for (KubernetesResource item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
  }
  public A withObjects(io.fabric8.kubernetes.api.model.KubernetesResource... objects) {
    if (this.objects != null) {this.objects.clear();}
    if (objects != null) {for (KubernetesResource item :objects){ this.addToObjects(item);}} return (A) this;
  }
  public Boolean hasObjects() {
    return objects != null && !objects.isEmpty();
  }
  public A addToJSONSchemaPropsOrArrayObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrArrayObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1JSONSchemaPropsOrArrayObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1JSONSchemaPropsOrArrayObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1JSONSchemaPropsOrArrayObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrArrayObjectsNested<A> addNewV1beta1JSONSchemaPropsOrArrayObject() {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrArrayObjectsNested<A> addNewJSONSchemaPropsOrArrayObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrArrayObjectsNested<A> setNewJSONSchemaPropsOrArrayObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl(index, item);
  }
  public A addToLabelSelectorObjects(Integer index,LabelSelector item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToLabelSelectorObjects(Integer index,LabelSelector item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToLabelSelectorObjects(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToLabelSelectorObjects(Collection<LabelSelector> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromLabelSelectorObjects(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromLabelSelectorObjects(Collection<LabelSelector> items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLabelSelectorObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.LabelSelectorObjectsNested<A> addNewLabelSelectorObject() {
    return new ConversionRequestFluentImpl.LabelSelectorObjectsNestedImpl();
  }
  public ConversionRequestFluent.LabelSelectorObjectsNested<A> addNewLabelSelectorObjectLike(LabelSelector item) {
    return new ConversionRequestFluentImpl.LabelSelectorObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.LabelSelectorObjectsNested<A> setNewLabelSelectorObjectLike(Integer index,LabelSelector item) {
    return new ConversionRequestFluentImpl.LabelSelectorObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionStatusObjects(Integer index,CustomResourceDefinitionStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionStatusObjects(Integer index,CustomResourceDefinitionStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionStatus item : items) {CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionStatusObjects(Collection<CustomResourceDefinitionStatus> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionStatus item : items) {CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus... items) {
    for (CustomResourceDefinitionStatus item : items) {CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionStatusObjects(Collection<CustomResourceDefinitionStatus> items) {
    for (CustomResourceDefinitionStatus item : items) {CustomResourceDefinitionStatusBuilder builder = new CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionStatusObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionStatusObjectsNested<A> addNewCustomResourceDefinitionStatusObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionStatusObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionStatusObjectsNested<A> addNewCustomResourceDefinitionStatusObjectLike(CustomResourceDefinitionStatus item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionStatusObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionStatusObjectsNested<A> setNewCustomResourceDefinitionStatusObjectLike(Integer index,CustomResourceDefinitionStatus item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionStatusObjectsNestedImpl(index, item);
  }
  public A addToServiceReferenceObjects(Integer index,ServiceReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToServiceReferenceObjects(Integer index,ServiceReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToServiceReferenceObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ServiceReference item : items) {ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToServiceReferenceObjects(Collection<ServiceReference> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ServiceReference item : items) {ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromServiceReferenceObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference... items) {
    for (ServiceReference item : items) {ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceReferenceObjects(Collection<ServiceReference> items) {
    for (ServiceReference item : items) {ServiceReferenceBuilder builder = new ServiceReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceReferenceObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ServiceReferenceObjectsNested<A> addNewServiceReferenceObject() {
    return new ConversionRequestFluentImpl.ServiceReferenceObjectsNestedImpl();
  }
  public ConversionRequestFluent.ServiceReferenceObjectsNested<A> addNewServiceReferenceObjectLike(ServiceReference item) {
    return new ConversionRequestFluentImpl.ServiceReferenceObjectsNestedImpl(-1, item);
  }
  public A addNewServiceReferenceObject(String name,String namespace,String path,Integer port) {
    return (A)addToServiceReferenceObjects(new ServiceReference(name, namespace, path, port));
  }
  public ConversionRequestFluent.ServiceReferenceObjectsNested<A> setNewServiceReferenceObjectLike(Integer index,ServiceReference item) {
    return new ConversionRequestFluentImpl.ServiceReferenceObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionStatusObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionStatusObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionStatusObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionStatusObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionStatusObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionStatusObjectsNested<A> addNewV1beta1CustomResourceDefinitionStatusObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionStatusObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionStatusObjectsNested<A> addNewCustomResourceDefinitionStatusObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionStatusObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionStatusObjectsNested<A> setNewCustomResourceDefinitionStatusObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionStatusObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsOrBoolObjects(Integer index,JSONSchemaPropsOrBool item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrBoolObjects(Integer index,JSONSchemaPropsOrBool item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrBoolObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBool... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrBool item : items) {JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToJSONSchemaPropsOrBoolObjects(Collection<JSONSchemaPropsOrBool> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrBool item : items) {JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrBoolObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBool... items) {
    for (JSONSchemaPropsOrBool item : items) {JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromJSONSchemaPropsOrBoolObjects(Collection<JSONSchemaPropsOrBool> items) {
    for (JSONSchemaPropsOrBool item : items) {JSONSchemaPropsOrBoolBuilder builder = new JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromJSONSchemaPropsOrBoolObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.JSONSchemaPropsOrBoolObjectsNested<A> addNewJSONSchemaPropsOrBoolObject() {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrBoolObjectsNestedImpl();
  }
  public ConversionRequestFluent.JSONSchemaPropsOrBoolObjectsNested<A> addNewJSONSchemaPropsOrBoolObjectLike(JSONSchemaPropsOrBool item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrBoolObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.JSONSchemaPropsOrBoolObjectsNested<A> setNewJSONSchemaPropsOrBoolObjectLike(Integer index,JSONSchemaPropsOrBool item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrBoolObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionSpecObjects(Integer index,CustomResourceDefinitionSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionSpecObjects(Integer index,CustomResourceDefinitionSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionSpecObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionSpec item : items) {CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionSpecObjects(Collection<CustomResourceDefinitionSpec> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionSpec item : items) {CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionSpecObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec... items) {
    for (CustomResourceDefinitionSpec item : items) {CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionSpecObjects(Collection<CustomResourceDefinitionSpec> items) {
    for (CustomResourceDefinitionSpec item : items) {CustomResourceDefinitionSpecBuilder builder = new CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionSpecObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionSpecObjectsNested<A> addNewCustomResourceDefinitionSpecObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionSpecObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionSpecObjectsNested<A> addNewCustomResourceDefinitionSpecObjectLike(CustomResourceDefinitionSpec item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionSpecObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionSpecObjectsNested<A> setNewCustomResourceDefinitionSpecObjectLike(Integer index,CustomResourceDefinitionSpec item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionSpecObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourceStatusObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourceStatusObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourceStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceSubresourceStatusObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourceStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceSubresourceStatusObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceSubresourceStatusObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceStatusObjectsNested<A> addNewV1beta1CustomResourceSubresourceStatusObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceStatusObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceStatusObjectsNested<A> addNewCustomResourceSubresourceStatusObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceStatusObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceStatusObjectsNested<A> setNewCustomResourceSubresourceStatusObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceStatusObjectsNestedImpl(index, item);
  }
  public A addToPodTemplateSpecObjects(Integer index,PodTemplateSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToPodTemplateSpecObjects(Integer index,PodTemplateSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToPodTemplateSpecObjects(io.fabric8.kubernetes.api.model.PodTemplateSpec... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (PodTemplateSpec item : items) {PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToPodTemplateSpecObjects(Collection<PodTemplateSpec> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (PodTemplateSpec item : items) {PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromPodTemplateSpecObjects(io.fabric8.kubernetes.api.model.PodTemplateSpec... items) {
    for (PodTemplateSpec item : items) {PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodTemplateSpecObjects(Collection<PodTemplateSpec> items) {
    for (PodTemplateSpec item : items) {PodTemplateSpecBuilder builder = new PodTemplateSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodTemplateSpecObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.PodTemplateSpecObjectsNested<A> addNewPodTemplateSpecObject() {
    return new ConversionRequestFluentImpl.PodTemplateSpecObjectsNestedImpl();
  }
  public ConversionRequestFluent.PodTemplateSpecObjectsNested<A> addNewPodTemplateSpecObjectLike(PodTemplateSpec item) {
    return new ConversionRequestFluentImpl.PodTemplateSpecObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.PodTemplateSpecObjectsNested<A> setNewPodTemplateSpecObjectLike(Integer index,PodTemplateSpec item) {
    return new ConversionRequestFluentImpl.PodTemplateSpecObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourceScaleObjects(Integer index,CustomResourceSubresourceScale item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourceScaleObjects(Integer index,CustomResourceSubresourceScale item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourceScaleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourceScale... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresourceScale item : items) {CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceSubresourceScaleObjects(Collection<CustomResourceSubresourceScale> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresourceScale item : items) {CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourceScaleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourceScale... items) {
    for (CustomResourceSubresourceScale item : items) {CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceSubresourceScaleObjects(Collection<CustomResourceSubresourceScale> items) {
    for (CustomResourceSubresourceScale item : items) {CustomResourceSubresourceScaleBuilder builder = new CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceSubresourceScaleObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceSubresourceScaleObjectsNested<A> addNewCustomResourceSubresourceScaleObject() {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceScaleObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceSubresourceScaleObjectsNested<A> addNewCustomResourceSubresourceScaleObjectLike(CustomResourceSubresourceScale item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceScaleObjectsNestedImpl(-1, item);
  }
  public A addNewCustomResourceSubresourceScaleObject(String labelSelectorPath,String specReplicasPath,String statusReplicasPath) {
    return (A)addToCustomResourceSubresourceScaleObjects(new CustomResourceSubresourceScale(labelSelectorPath, specReplicasPath, statusReplicasPath));
  }
  public ConversionRequestFluent.CustomResourceSubresourceScaleObjectsNested<A> setNewCustomResourceSubresourceScaleObjectLike(Integer index,CustomResourceSubresourceScale item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceScaleObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionNamesObjects(Integer index,CustomResourceDefinitionNames item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionNamesObjects(Integer index,CustomResourceDefinitionNames item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionNamesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionNames item : items) {CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionNamesObjects(Collection<CustomResourceDefinitionNames> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionNames item : items) {CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionNamesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames... items) {
    for (CustomResourceDefinitionNames item : items) {CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionNamesObjects(Collection<CustomResourceDefinitionNames> items) {
    for (CustomResourceDefinitionNames item : items) {CustomResourceDefinitionNamesBuilder builder = new CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionNamesObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionNamesObjectsNested<A> addNewCustomResourceDefinitionNamesObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionNamesObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionNamesObjectsNested<A> addNewCustomResourceDefinitionNamesObjectLike(CustomResourceDefinitionNames item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionNamesObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionNamesObjectsNested<A> setNewCustomResourceDefinitionNamesObjectLike(Integer index,CustomResourceDefinitionNames item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionNamesObjectsNestedImpl(index, item);
  }
  public A addToExternalDocumentationObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToExternalDocumentationObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToExternalDocumentationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1ExternalDocumentationObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromExternalDocumentationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1ExternalDocumentationObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1ExternalDocumentationObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1ExternalDocumentationObjectsNested<A> addNewV1beta1ExternalDocumentationObject() {
    return new ConversionRequestFluentImpl.V1beta1ExternalDocumentationObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1ExternalDocumentationObjectsNested<A> addNewExternalDocumentationObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    return new ConversionRequestFluentImpl.V1beta1ExternalDocumentationObjectsNestedImpl(-1, item);
  }
  public A addNewV1beta1ExternalDocumentationObject(String description,String url) {
    return (A)addToExternalDocumentationObjects(new ExternalDocumentation(description, url));
  }
  public ConversionRequestFluent.V1beta1ExternalDocumentationObjectsNested<A> setNewExternalDocumentationObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    return new ConversionRequestFluentImpl.V1beta1ExternalDocumentationObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourceScaleObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourceScaleObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourceScaleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceSubresourceScaleObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourceScaleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceSubresourceScaleObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceSubresourceScaleObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceScaleObjectsNested<A> addNewV1beta1CustomResourceSubresourceScaleObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceScaleObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceScaleObjectsNested<A> addNewCustomResourceSubresourceScaleObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceScaleObjectsNestedImpl(-1, item);
  }
  public A addNewV1beta1CustomResourceSubresourceScaleObject(String labelSelectorPath,String specReplicasPath,String statusReplicasPath) {
    return (A)addToCustomResourceSubresourceScaleObjects(new CustomResourceSubresourceScale(labelSelectorPath, specReplicasPath, statusReplicasPath));
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourceScaleObjectsNested<A> setNewCustomResourceSubresourceScaleObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourceScaleObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionConditionObjects(Integer index,CustomResourceDefinitionCondition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionConditionObjects(Integer index,CustomResourceDefinitionCondition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionConditionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionCondition item : items) {CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionConditionObjects(Collection<CustomResourceDefinitionCondition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionCondition item : items) {CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionConditionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition... items) {
    for (CustomResourceDefinitionCondition item : items) {CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionConditionObjects(Collection<CustomResourceDefinitionCondition> items) {
    for (CustomResourceDefinitionCondition item : items) {CustomResourceDefinitionConditionBuilder builder = new CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionConditionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionConditionObjectsNested<A> addNewCustomResourceDefinitionConditionObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionConditionObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionConditionObjectsNested<A> addNewCustomResourceDefinitionConditionObjectLike(CustomResourceDefinitionCondition item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionConditionObjectsNestedImpl(-1, item);
  }
  public A addNewCustomResourceDefinitionConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToCustomResourceDefinitionConditionObjects(new CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
  }
  public ConversionRequestFluent.CustomResourceDefinitionConditionObjectsNested<A> setNewCustomResourceDefinitionConditionObjectLike(Integer index,CustomResourceDefinitionCondition item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionConditionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourceStatusObjects(Integer index,CustomResourceSubresourceStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourceStatusObjects(Integer index,CustomResourceSubresourceStatus item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourceStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourceStatus... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresourceStatus item : items) {CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceSubresourceStatusObjects(Collection<CustomResourceSubresourceStatus> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresourceStatus item : items) {CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourceStatusObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourceStatus... items) {
    for (CustomResourceSubresourceStatus item : items) {CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceSubresourceStatusObjects(Collection<CustomResourceSubresourceStatus> items) {
    for (CustomResourceSubresourceStatus item : items) {CustomResourceSubresourceStatusBuilder builder = new CustomResourceSubresourceStatusBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceSubresourceStatusObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceSubresourceStatusObjectsNested<A> addNewCustomResourceSubresourceStatusObject() {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceStatusObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceSubresourceStatusObjectsNested<A> addNewCustomResourceSubresourceStatusObjectLike(CustomResourceSubresourceStatus item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceStatusObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceSubresourceStatusObjectsNested<A> setNewCustomResourceSubresourceStatusObjectLike(Integer index,CustomResourceSubresourceStatus item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourceStatusObjectsNestedImpl(index, item);
  }
  public A addToResourceRequirementsObjects(Integer index,ResourceRequirements item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToResourceRequirementsObjects(Integer index,ResourceRequirements item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToResourceRequirementsObjects(io.fabric8.kubernetes.api.model.ResourceRequirements... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ResourceRequirements item : items) {ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToResourceRequirementsObjects(Collection<ResourceRequirements> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ResourceRequirements item : items) {ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromResourceRequirementsObjects(io.fabric8.kubernetes.api.model.ResourceRequirements... items) {
    for (ResourceRequirements item : items) {ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceRequirementsObjects(Collection<ResourceRequirements> items) {
    for (ResourceRequirements item : items) {ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceRequirementsObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ResourceRequirementsObjectsNested<A> addNewResourceRequirementsObject() {
    return new ConversionRequestFluentImpl.ResourceRequirementsObjectsNestedImpl();
  }
  public ConversionRequestFluent.ResourceRequirementsObjectsNested<A> addNewResourceRequirementsObjectLike(ResourceRequirements item) {
    return new ConversionRequestFluentImpl.ResourceRequirementsObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ResourceRequirementsObjectsNested<A> setNewResourceRequirementsObjectLike(Integer index,ResourceRequirements item) {
    return new ConversionRequestFluentImpl.ResourceRequirementsObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceValidationObjects(Integer index,CustomResourceValidation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceValidationObjects(Integer index,CustomResourceValidation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceValidationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidation... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceValidation item : items) {CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceValidationObjects(Collection<CustomResourceValidation> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceValidation item : items) {CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceValidationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidation... items) {
    for (CustomResourceValidation item : items) {CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceValidationObjects(Collection<CustomResourceValidation> items) {
    for (CustomResourceValidation item : items) {CustomResourceValidationBuilder builder = new CustomResourceValidationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceValidationObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceValidationObjectsNested<A> addNewCustomResourceValidationObject() {
    return new ConversionRequestFluentImpl.CustomResourceValidationObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceValidationObjectsNested<A> addNewCustomResourceValidationObjectLike(CustomResourceValidation item) {
    return new ConversionRequestFluentImpl.CustomResourceValidationObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceValidationObjectsNested<A> setNewCustomResourceValidationObjectLike(Integer index,CustomResourceValidation item) {
    return new ConversionRequestFluentImpl.CustomResourceValidationObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionVersionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionVersionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionVersionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionVersionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionVersionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionVersionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionVersionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionVersionObjectsNested<A> addNewV1beta1CustomResourceDefinitionVersionObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionVersionObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionVersionObjectsNested<A> addNewCustomResourceDefinitionVersionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionVersionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionVersionObjectsNested<A> setNewCustomResourceDefinitionVersionObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionVersionObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1JSONSchemaPropsObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1JSONSchemaPropsObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1JSONSchemaPropsObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsObjectsNested<A> addNewV1beta1JSONSchemaPropsObject() {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsObjectsNested<A> addNewJSONSchemaPropsObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsObjectsNested<A> setNewJSONSchemaPropsObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsObjectsNestedImpl(index, item);
  }
  public A addToConversionResponseObjects(Integer index,ConversionResponse item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionResponseBuilder builder = new ConversionResponseBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToConversionResponseObjects(Integer index,ConversionResponse item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionResponseBuilder builder = new ConversionResponseBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToConversionResponseObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponse... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionResponse item : items) {ConversionResponseBuilder builder = new ConversionResponseBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToConversionResponseObjects(Collection<ConversionResponse> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionResponse item : items) {ConversionResponseBuilder builder = new ConversionResponseBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromConversionResponseObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponse... items) {
    for (ConversionResponse item : items) {ConversionResponseBuilder builder = new ConversionResponseBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromConversionResponseObjects(Collection<ConversionResponse> items) {
    for (ConversionResponse item : items) {ConversionResponseBuilder builder = new ConversionResponseBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConversionResponseObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ConversionResponseObjectsNested<A> addNewConversionResponseObject() {
    return new ConversionRequestFluentImpl.ConversionResponseObjectsNestedImpl();
  }
  public ConversionRequestFluent.ConversionResponseObjectsNested<A> addNewConversionResponseObjectLike(ConversionResponse item) {
    return new ConversionRequestFluentImpl.ConversionResponseObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ConversionResponseObjectsNested<A> setNewConversionResponseObjectLike(Integer index,ConversionResponse item) {
    return new ConversionRequestFluentImpl.ConversionResponseObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsOrBoolObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrBoolObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrBoolObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1JSONSchemaPropsOrBoolObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrBoolObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1JSONSchemaPropsOrBoolObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1JSONSchemaPropsOrBoolObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrBoolObjectsNested<A> addNewV1beta1JSONSchemaPropsOrBoolObject() {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrBoolObjectsNested<A> addNewJSONSchemaPropsOrBoolObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrBoolObjectsNested<A> setNewJSONSchemaPropsOrBoolObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl(index, item);
  }
  public A addToRawExtensionObjects(Integer index,RawExtension item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    RawExtensionBuilder builder = new RawExtensionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRawExtensionObjects(Integer index,RawExtension item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    RawExtensionBuilder builder = new RawExtensionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRawExtensionObjects(io.fabric8.kubernetes.api.model.runtime.RawExtension... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (RawExtension item : items) {RawExtensionBuilder builder = new RawExtensionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRawExtensionObjects(Collection<RawExtension> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (RawExtension item : items) {RawExtensionBuilder builder = new RawExtensionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRawExtensionObjects(io.fabric8.kubernetes.api.model.runtime.RawExtension... items) {
    for (RawExtension item : items) {RawExtensionBuilder builder = new RawExtensionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRawExtensionObjects(Collection<RawExtension> items) {
    for (RawExtension item : items) {RawExtensionBuilder builder = new RawExtensionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRawExtensionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.RawExtensionObjectsNested<A> addNewRawExtensionObject() {
    return new ConversionRequestFluentImpl.RawExtensionObjectsNestedImpl();
  }
  public ConversionRequestFluent.RawExtensionObjectsNested<A> addNewRawExtensionObjectLike(RawExtension item) {
    return new ConversionRequestFluentImpl.RawExtensionObjectsNestedImpl(-1, item);
  }
  public A addNewRawExtensionObject(Object value) {
    return (A)addToRawExtensionObjects(new RawExtension(value));
  }
  public ConversionRequestFluent.RawExtensionObjectsNested<A> setNewRawExtensionObjectLike(Integer index,RawExtension item) {
    return new ConversionRequestFluentImpl.RawExtensionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionNamesObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionNamesObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionNamesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionNamesObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionNamesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionNamesObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionNamesObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionNamesObjectsNested<A> addNewV1beta1CustomResourceDefinitionNamesObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionNamesObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionNamesObjectsNested<A> addNewCustomResourceDefinitionNamesObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionNamesObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionNamesObjectsNested<A> setNewCustomResourceDefinitionNamesObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionNamesObjectsNestedImpl(index, item);
  }
  public A addToValidationRuleObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToValidationRuleObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToValidationRuleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1ValidationRuleObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromValidationRuleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1ValidationRuleObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1ValidationRuleObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1ValidationRuleObjectsNested<A> addNewV1beta1ValidationRuleObject() {
    return new ConversionRequestFluentImpl.V1beta1ValidationRuleObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1ValidationRuleObjectsNested<A> addNewValidationRuleObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    return new ConversionRequestFluentImpl.V1beta1ValidationRuleObjectsNestedImpl(-1, item);
  }
  public A addNewV1beta1ValidationRuleObject(String message,String rule) {
    return (A)addToValidationRuleObjects(new ValidationRule(message, rule));
  }
  public ConversionRequestFluent.V1beta1ValidationRuleObjectsNested<A> setNewValidationRuleObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    return new ConversionRequestFluentImpl.V1beta1ValidationRuleObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsOrStringArrayObjects(Integer index,JSONSchemaPropsOrStringArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrStringArrayObjects(Integer index,JSONSchemaPropsOrStringArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrStringArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrStringArray item : items) {JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToJSONSchemaPropsOrStringArrayObjects(Collection<JSONSchemaPropsOrStringArray> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrStringArray item : items) {JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrStringArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray... items) {
    for (JSONSchemaPropsOrStringArray item : items) {JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromJSONSchemaPropsOrStringArrayObjects(Collection<JSONSchemaPropsOrStringArray> items) {
    for (JSONSchemaPropsOrStringArray item : items) {JSONSchemaPropsOrStringArrayBuilder builder = new JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromJSONSchemaPropsOrStringArrayObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.JSONSchemaPropsOrStringArrayObjectsNested<A> addNewJSONSchemaPropsOrStringArrayObject() {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrStringArrayObjectsNestedImpl();
  }
  public ConversionRequestFluent.JSONSchemaPropsOrStringArrayObjectsNested<A> addNewJSONSchemaPropsOrStringArrayObjectLike(JSONSchemaPropsOrStringArray item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrStringArrayObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.JSONSchemaPropsOrStringArrayObjectsNested<A> setNewJSONSchemaPropsOrStringArrayObjectLike(Integer index,JSONSchemaPropsOrStringArray item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrStringArrayObjectsNestedImpl(index, item);
  }
  public A addToObjectMetaObjects(Integer index,ObjectMeta item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ObjectMetaBuilder builder = new ObjectMetaBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToObjectMetaObjects(Integer index,ObjectMeta item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ObjectMetaBuilder builder = new ObjectMetaBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToObjectMetaObjects(io.fabric8.kubernetes.api.model.ObjectMeta... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ObjectMeta item : items) {ObjectMetaBuilder builder = new ObjectMetaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToObjectMetaObjects(Collection<ObjectMeta> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ObjectMeta item : items) {ObjectMetaBuilder builder = new ObjectMetaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromObjectMetaObjects(io.fabric8.kubernetes.api.model.ObjectMeta... items) {
    for (ObjectMeta item : items) {ObjectMetaBuilder builder = new ObjectMetaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromObjectMetaObjects(Collection<ObjectMeta> items) {
    for (ObjectMeta item : items) {ObjectMetaBuilder builder = new ObjectMetaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromObjectMetaObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ObjectMetaObjectsNested<A> addNewObjectMetaObject() {
    return new ConversionRequestFluentImpl.ObjectMetaObjectsNestedImpl();
  }
  public ConversionRequestFluent.ObjectMetaObjectsNested<A> addNewObjectMetaObjectLike(ObjectMeta item) {
    return new ConversionRequestFluentImpl.ObjectMetaObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ObjectMetaObjectsNested<A> setNewObjectMetaObjectLike(Integer index,ObjectMeta item) {
    return new ConversionRequestFluentImpl.ObjectMetaObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourcesObjects(Integer index,CustomResourceSubresources item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourcesObjects(Integer index,CustomResourceSubresources item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourcesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresources... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresources item : items) {CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceSubresourcesObjects(Collection<CustomResourceSubresources> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceSubresources item : items) {CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourcesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresources... items) {
    for (CustomResourceSubresources item : items) {CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceSubresourcesObjects(Collection<CustomResourceSubresources> items) {
    for (CustomResourceSubresources item : items) {CustomResourceSubresourcesBuilder builder = new CustomResourceSubresourcesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceSubresourcesObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceSubresourcesObjectsNested<A> addNewCustomResourceSubresourcesObject() {
    return new ConversionRequestFluentImpl.CustomResourceSubresourcesObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceSubresourcesObjectsNested<A> addNewCustomResourceSubresourcesObjectLike(CustomResourceSubresources item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourcesObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceSubresourcesObjectsNested<A> setNewCustomResourceSubresourcesObjectLike(Integer index,CustomResourceSubresources item) {
    return new ConversionRequestFluentImpl.CustomResourceSubresourcesObjectsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimObjects(Integer index,PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeClaimObjects(Integer index,PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject() {
    return new ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl();
  }
  public ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item) {
    return new ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(Integer index,PersistentVolumeClaim item) {
    return new ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl(index, item);
  }
  public A addToConversionRequestObjects(Integer index,ConversionRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionRequestBuilder builder = new ConversionRequestBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToConversionRequestObjects(Integer index,ConversionRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionRequestBuilder builder = new ConversionRequestBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToConversionRequestObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionRequest item : items) {ConversionRequestBuilder builder = new ConversionRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToConversionRequestObjects(Collection<ConversionRequest> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionRequest item : items) {ConversionRequestBuilder builder = new ConversionRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromConversionRequestObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest... items) {
    for (ConversionRequest item : items) {ConversionRequestBuilder builder = new ConversionRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromConversionRequestObjects(Collection<ConversionRequest> items) {
    for (ConversionRequest item : items) {ConversionRequestBuilder builder = new ConversionRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConversionRequestObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ConversionRequestObjectsNested<A> addNewConversionRequestObject() {
    return new ConversionRequestFluentImpl.ConversionRequestObjectsNestedImpl();
  }
  public ConversionRequestFluent.ConversionRequestObjectsNested<A> addNewConversionRequestObjectLike(ConversionRequest item) {
    return new ConversionRequestFluentImpl.ConversionRequestObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ConversionRequestObjectsNested<A> setNewConversionRequestObjectLike(Integer index,ConversionRequest item) {
    return new ConversionRequestFluentImpl.ConversionRequestObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsObjects(Integer index,JSONSchemaProps item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsObjects(Integer index,JSONSchemaProps item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToJSONSchemaPropsObjects(Collection<JSONSchemaProps> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromJSONSchemaPropsObjects(Collection<JSONSchemaProps> items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromJSONSchemaPropsObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.JSONSchemaPropsObjectsNested<A> addNewJSONSchemaPropsObject() {
    return new ConversionRequestFluentImpl.JSONSchemaPropsObjectsNestedImpl();
  }
  public ConversionRequestFluent.JSONSchemaPropsObjectsNested<A> addNewJSONSchemaPropsObjectLike(JSONSchemaProps item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.JSONSchemaPropsObjectsNested<A> setNewJSONSchemaPropsObjectLike(Integer index,JSONSchemaProps item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsOrStringArrayObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrStringArrayObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrStringArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1JSONSchemaPropsOrStringArrayObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrStringArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1JSONSchemaPropsOrStringArrayObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1JSONSchemaPropsOrStringArrayObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrStringArrayObjectsNested<A> addNewV1beta1JSONSchemaPropsOrStringArrayObject() {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrStringArrayObjectsNested<A> addNewJSONSchemaPropsOrStringArrayObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1JSONSchemaPropsOrStringArrayObjectsNested<A> setNewJSONSchemaPropsOrStringArrayObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    return new ConversionRequestFluentImpl.V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl(index, item);
  }
  public A addToWebhookClientConfigObjects(Integer index,WebhookClientConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToWebhookClientConfigObjects(Integer index,WebhookClientConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToWebhookClientConfigObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (WebhookClientConfig item : items) {WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToWebhookClientConfigObjects(Collection<WebhookClientConfig> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (WebhookClientConfig item : items) {WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromWebhookClientConfigObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig... items) {
    for (WebhookClientConfig item : items) {WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromWebhookClientConfigObjects(Collection<WebhookClientConfig> items) {
    for (WebhookClientConfig item : items) {WebhookClientConfigBuilder builder = new WebhookClientConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWebhookClientConfigObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.WebhookClientConfigObjectsNested<A> addNewWebhookClientConfigObject() {
    return new ConversionRequestFluentImpl.WebhookClientConfigObjectsNestedImpl();
  }
  public ConversionRequestFluent.WebhookClientConfigObjectsNested<A> addNewWebhookClientConfigObjectLike(WebhookClientConfig item) {
    return new ConversionRequestFluentImpl.WebhookClientConfigObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.WebhookClientConfigObjectsNested<A> setNewWebhookClientConfigObjectLike(Integer index,WebhookClientConfig item) {
    return new ConversionRequestFluentImpl.WebhookClientConfigObjectsNestedImpl(index, item);
  }
  public A addToContainerObjects(Integer index,Container item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToContainerObjects(Integer index,Container item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToContainerObjects(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToContainerObjects(Collection<Container> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromContainerObjects(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerObjects(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ContainerObjectsNested<A> addNewContainerObject() {
    return new ConversionRequestFluentImpl.ContainerObjectsNestedImpl();
  }
  public ConversionRequestFluent.ContainerObjectsNested<A> addNewContainerObjectLike(Container item) {
    return new ConversionRequestFluentImpl.ContainerObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ContainerObjectsNested<A> setNewContainerObjectLike(Integer index,Container item) {
    return new ConversionRequestFluentImpl.ContainerObjectsNestedImpl(index, item);
  }
  public A addToGenericKubernetesResourceObjects(Integer index,GenericKubernetesResource item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToGenericKubernetesResourceObjects(Integer index,GenericKubernetesResource item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToGenericKubernetesResourceObjects(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToGenericKubernetesResourceObjects(Collection<GenericKubernetesResource> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromGenericKubernetesResourceObjects(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenericKubernetesResourceObjects(Collection<GenericKubernetesResource> items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenericKubernetesResourceObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObject() {
    return new ConversionRequestFluentImpl.GenericKubernetesResourceObjectsNestedImpl();
  }
  public ConversionRequestFluent.GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObjectLike(GenericKubernetesResource item) {
    return new ConversionRequestFluentImpl.GenericKubernetesResourceObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.GenericKubernetesResourceObjectsNested<A> setNewGenericKubernetesResourceObjectLike(Integer index,GenericKubernetesResource item) {
    return new ConversionRequestFluentImpl.GenericKubernetesResourceObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceColumnDefinitionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceColumnDefinitionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceColumnDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceColumnDefinitionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceColumnDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceColumnDefinitionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceColumnDefinitionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceColumnDefinitionObjectsNested<A> addNewV1beta1CustomResourceColumnDefinitionObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceColumnDefinitionObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceColumnDefinitionObjectsNested<A> addNewCustomResourceColumnDefinitionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceColumnDefinitionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceColumnDefinitionObjectsNested<A> setNewCustomResourceColumnDefinitionObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceColumnDefinitionObjectsNestedImpl(index, item);
  }
  public A addToWebhookClientConfigObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToWebhookClientConfigObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToWebhookClientConfigObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1WebhookClientConfigObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromWebhookClientConfigObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1WebhookClientConfigObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1WebhookClientConfigObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1WebhookClientConfigObjectsNested<A> addNewV1beta1WebhookClientConfigObject() {
    return new ConversionRequestFluentImpl.V1beta1WebhookClientConfigObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1WebhookClientConfigObjectsNested<A> addNewWebhookClientConfigObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    return new ConversionRequestFluentImpl.V1beta1WebhookClientConfigObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1WebhookClientConfigObjectsNested<A> setNewWebhookClientConfigObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    return new ConversionRequestFluentImpl.V1beta1WebhookClientConfigObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceColumnDefinitionObjects(Integer index,CustomResourceColumnDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceColumnDefinitionObjects(Integer index,CustomResourceColumnDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceColumnDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceColumnDefinitionObjects(Collection<CustomResourceColumnDefinition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceColumnDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceColumnDefinitionObjects(Collection<CustomResourceColumnDefinition> items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceColumnDefinitionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceColumnDefinitionObjectsNested<A> addNewCustomResourceColumnDefinitionObject() {
    return new ConversionRequestFluentImpl.CustomResourceColumnDefinitionObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceColumnDefinitionObjectsNested<A> addNewCustomResourceColumnDefinitionObjectLike(CustomResourceColumnDefinition item) {
    return new ConversionRequestFluentImpl.CustomResourceColumnDefinitionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceColumnDefinitionObjectsNested<A> setNewCustomResourceColumnDefinitionObjectLike(Integer index,CustomResourceColumnDefinition item) {
    return new ConversionRequestFluentImpl.CustomResourceColumnDefinitionObjectsNestedImpl(index, item);
  }
  public A addToWebhookConversionObjects(Integer index,WebhookConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    WebhookConversionBuilder builder = new WebhookConversionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToWebhookConversionObjects(Integer index,WebhookConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    WebhookConversionBuilder builder = new WebhookConversionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToWebhookConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (WebhookConversion item : items) {WebhookConversionBuilder builder = new WebhookConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToWebhookConversionObjects(Collection<WebhookConversion> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (WebhookConversion item : items) {WebhookConversionBuilder builder = new WebhookConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromWebhookConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion... items) {
    for (WebhookConversion item : items) {WebhookConversionBuilder builder = new WebhookConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromWebhookConversionObjects(Collection<WebhookConversion> items) {
    for (WebhookConversion item : items) {WebhookConversionBuilder builder = new WebhookConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWebhookConversionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.WebhookConversionObjectsNested<A> addNewWebhookConversionObject() {
    return new ConversionRequestFluentImpl.WebhookConversionObjectsNestedImpl();
  }
  public ConversionRequestFluent.WebhookConversionObjectsNested<A> addNewWebhookConversionObjectLike(WebhookConversion item) {
    return new ConversionRequestFluentImpl.WebhookConversionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.WebhookConversionObjectsNested<A> setNewWebhookConversionObjectLike(Integer index,WebhookConversion item) {
    return new ConversionRequestFluentImpl.WebhookConversionObjectsNestedImpl(index, item);
  }
  public A addToLocalObjectReferenceObjects(Integer index,LocalObjectReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToLocalObjectReferenceObjects(Integer index,LocalObjectReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToLocalObjectReferenceObjects(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToLocalObjectReferenceObjects(Collection<LocalObjectReference> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromLocalObjectReferenceObjects(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromLocalObjectReferenceObjects(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLocalObjectReferenceObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.LocalObjectReferenceObjectsNested<A> addNewLocalObjectReferenceObject() {
    return new ConversionRequestFluentImpl.LocalObjectReferenceObjectsNestedImpl();
  }
  public ConversionRequestFluent.LocalObjectReferenceObjectsNested<A> addNewLocalObjectReferenceObjectLike(LocalObjectReference item) {
    return new ConversionRequestFluentImpl.LocalObjectReferenceObjectsNestedImpl(-1, item);
  }
  public A addNewLocalObjectReferenceObject(String name) {
    return (A)addToLocalObjectReferenceObjects(new LocalObjectReference(name));
  }
  public ConversionRequestFluent.LocalObjectReferenceObjectsNested<A> setNewLocalObjectReferenceObjectLike(Integer index,LocalObjectReference item) {
    return new ConversionRequestFluentImpl.LocalObjectReferenceObjectsNestedImpl(index, item);
  }
  public A addToExternalDocumentationObjects(Integer index,ExternalDocumentation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToExternalDocumentationObjects(Integer index,ExternalDocumentation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToExternalDocumentationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ExternalDocumentation... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ExternalDocumentation item : items) {ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToExternalDocumentationObjects(Collection<ExternalDocumentation> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ExternalDocumentation item : items) {ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromExternalDocumentationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ExternalDocumentation... items) {
    for (ExternalDocumentation item : items) {ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromExternalDocumentationObjects(Collection<ExternalDocumentation> items) {
    for (ExternalDocumentation item : items) {ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExternalDocumentationObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ExternalDocumentationObjectsNested<A> addNewExternalDocumentationObject() {
    return new ConversionRequestFluentImpl.ExternalDocumentationObjectsNestedImpl();
  }
  public ConversionRequestFluent.ExternalDocumentationObjectsNested<A> addNewExternalDocumentationObjectLike(ExternalDocumentation item) {
    return new ConversionRequestFluentImpl.ExternalDocumentationObjectsNestedImpl(-1, item);
  }
  public A addNewExternalDocumentationObject(String description,String url) {
    return (A)addToExternalDocumentationObjects(new ExternalDocumentation(description, url));
  }
  public ConversionRequestFluent.ExternalDocumentationObjectsNested<A> setNewExternalDocumentationObjectLike(Integer index,ExternalDocumentation item) {
    return new ConversionRequestFluentImpl.ExternalDocumentationObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceSubresourcesObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceSubresourcesObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceSubresourcesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceSubresourcesObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceSubresourcesObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceSubresourcesObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceSubresourcesObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourcesObjectsNested<A> addNewV1beta1CustomResourceSubresourcesObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourcesObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourcesObjectsNested<A> addNewCustomResourceSubresourcesObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourcesObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceSubresourcesObjectsNested<A> setNewCustomResourceSubresourcesObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceSubresourcesObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionVersionObjects(Integer index,CustomResourceDefinitionVersion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionVersionObjects(Integer index,CustomResourceDefinitionVersion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionVersionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionVersionObjects(Collection<CustomResourceDefinitionVersion> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionVersionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion... items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionVersionObjects(Collection<CustomResourceDefinitionVersion> items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionVersionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionVersionObjectsNested<A> addNewCustomResourceDefinitionVersionObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionVersionObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionVersionObjectsNested<A> addNewCustomResourceDefinitionVersionObjectLike(CustomResourceDefinitionVersion item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionVersionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionVersionObjectsNested<A> setNewCustomResourceDefinitionVersionObjectLike(Integer index,CustomResourceDefinitionVersion item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionVersionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceConversionObjects(Integer index,CustomResourceConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceConversionObjects(Integer index,CustomResourceConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceConversion item : items) {CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceConversionObjects(Collection<CustomResourceConversion> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceConversion item : items) {CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion... items) {
    for (CustomResourceConversion item : items) {CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceConversionObjects(Collection<CustomResourceConversion> items) {
    for (CustomResourceConversion item : items) {CustomResourceConversionBuilder builder = new CustomResourceConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceConversionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceConversionObjectsNested<A> addNewCustomResourceConversionObject() {
    return new ConversionRequestFluentImpl.CustomResourceConversionObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceConversionObjectsNested<A> addNewCustomResourceConversionObjectLike(CustomResourceConversion item) {
    return new ConversionRequestFluentImpl.CustomResourceConversionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceConversionObjectsNested<A> setNewCustomResourceConversionObjectLike(Integer index,CustomResourceConversion item) {
    return new ConversionRequestFluentImpl.CustomResourceConversionObjectsNestedImpl(index, item);
  }
  public A addToValidationRuleObjects(Integer index,ValidationRule item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToValidationRuleObjects(Integer index,ValidationRule item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToValidationRuleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ValidationRule... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToValidationRuleObjects(Collection<ValidationRule> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromValidationRuleObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ValidationRule... items) {
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromValidationRuleObjects(Collection<ValidationRule> items) {
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValidationRuleObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ValidationRuleObjectsNested<A> addNewValidationRuleObject() {
    return new ConversionRequestFluentImpl.ValidationRuleObjectsNestedImpl();
  }
  public ConversionRequestFluent.ValidationRuleObjectsNested<A> addNewValidationRuleObjectLike(ValidationRule item) {
    return new ConversionRequestFluentImpl.ValidationRuleObjectsNestedImpl(-1, item);
  }
  public A addNewValidationRuleObject(String message,String rule) {
    return (A)addToValidationRuleObjects(new ValidationRule(message, rule));
  }
  public ConversionRequestFluent.ValidationRuleObjectsNested<A> setNewValidationRuleObjectLike(Integer index,ValidationRule item) {
    return new ConversionRequestFluentImpl.ValidationRuleObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionObjects(Integer index,CustomResourceDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionObjects(Integer index,CustomResourceDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionObjects(Collection<CustomResourceDefinition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition... items) {
    for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionObjects(Collection<CustomResourceDefinition> items) {
    for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObjectLike(CustomResourceDefinition item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> setNewCustomResourceDefinitionObjectLike(Integer index,CustomResourceDefinition item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionConditionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionConditionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionConditionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionConditionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionConditionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionConditionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionConditionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionConditionObjectsNested<A> addNewV1beta1CustomResourceDefinitionConditionObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionConditionObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionConditionObjectsNested<A> addNewCustomResourceDefinitionConditionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionConditionObjectsNestedImpl(-1, item);
  }
  public A addNewV1beta1CustomResourceDefinitionConditionObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToCustomResourceDefinitionConditionObjects(new CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionConditionObjectsNested<A> setNewCustomResourceDefinitionConditionObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionConditionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionListObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionListObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionListObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionListObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionListObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionListObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionListObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionListObjectsNested<A> addNewV1beta1CustomResourceDefinitionListObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionListObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionListObjectsNested<A> addNewCustomResourceDefinitionListObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionListObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionListObjectsNested<A> setNewCustomResourceDefinitionListObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionListObjectsNestedImpl(index, item);
  }
  public A addToServiceReferenceObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToServiceReferenceObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToServiceReferenceObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1ServiceReferenceObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromServiceReferenceObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1ServiceReferenceObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1ServiceReferenceObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1ServiceReferenceObjectsNested<A> addNewV1beta1ServiceReferenceObject() {
    return new ConversionRequestFluentImpl.V1beta1ServiceReferenceObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1ServiceReferenceObjectsNested<A> addNewServiceReferenceObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    return new ConversionRequestFluentImpl.V1beta1ServiceReferenceObjectsNestedImpl(-1, item);
  }
  public A addNewV1beta1ServiceReferenceObject(String name,String namespace,String path,Integer port) {
    return (A)addToServiceReferenceObjects(new ServiceReference(name, namespace, path, port));
  }
  public ConversionRequestFluent.V1beta1ServiceReferenceObjectsNested<A> setNewServiceReferenceObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    return new ConversionRequestFluentImpl.V1beta1ServiceReferenceObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionListObjects(Integer index,CustomResourceDefinitionList item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionListObjects(Integer index,CustomResourceDefinitionList item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionListObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionList item : items) {CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToCustomResourceDefinitionListObjects(Collection<CustomResourceDefinitionList> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (CustomResourceDefinitionList item : items) {CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionListObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList... items) {
    for (CustomResourceDefinitionList item : items) {CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomResourceDefinitionListObjects(Collection<CustomResourceDefinitionList> items) {
    for (CustomResourceDefinitionList item : items) {CustomResourceDefinitionListBuilder builder = new CustomResourceDefinitionListBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomResourceDefinitionListObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.CustomResourceDefinitionListObjectsNested<A> addNewCustomResourceDefinitionListObject() {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionListObjectsNestedImpl();
  }
  public ConversionRequestFluent.CustomResourceDefinitionListObjectsNested<A> addNewCustomResourceDefinitionListObjectLike(CustomResourceDefinitionList item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionListObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.CustomResourceDefinitionListObjectsNested<A> setNewCustomResourceDefinitionListObjectLike(Integer index,CustomResourceDefinitionList item) {
    return new ConversionRequestFluentImpl.CustomResourceDefinitionListObjectsNestedImpl(index, item);
  }
  public A addToObjectReferenceObjects(Integer index,ObjectReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToObjectReferenceObjects(Integer index,ObjectReference item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToObjectReferenceObjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToObjectReferenceObjects(Collection<ObjectReference> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromObjectReferenceObjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromObjectReferenceObjects(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromObjectReferenceObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ObjectReferenceObjectsNested<A> addNewObjectReferenceObject() {
    return new ConversionRequestFluentImpl.ObjectReferenceObjectsNestedImpl();
  }
  public ConversionRequestFluent.ObjectReferenceObjectsNested<A> addNewObjectReferenceObjectLike(ObjectReference item) {
    return new ConversionRequestFluentImpl.ObjectReferenceObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ObjectReferenceObjectsNested<A> setNewObjectReferenceObjectLike(Integer index,ObjectReference item) {
    return new ConversionRequestFluentImpl.ObjectReferenceObjectsNestedImpl(index, item);
  }
  public A addToJSONSchemaPropsOrArrayObjects(Integer index,JSONSchemaPropsOrArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToJSONSchemaPropsOrArrayObjects(Integer index,JSONSchemaPropsOrArray item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToJSONSchemaPropsOrArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrArray item : items) {JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToJSONSchemaPropsOrArrayObjects(Collection<JSONSchemaPropsOrArray> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (JSONSchemaPropsOrArray item : items) {JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromJSONSchemaPropsOrArrayObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray... items) {
    for (JSONSchemaPropsOrArray item : items) {JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromJSONSchemaPropsOrArrayObjects(Collection<JSONSchemaPropsOrArray> items) {
    for (JSONSchemaPropsOrArray item : items) {JSONSchemaPropsOrArrayBuilder builder = new JSONSchemaPropsOrArrayBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromJSONSchemaPropsOrArrayObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.JSONSchemaPropsOrArrayObjectsNested<A> addNewJSONSchemaPropsOrArrayObject() {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrArrayObjectsNestedImpl();
  }
  public ConversionRequestFluent.JSONSchemaPropsOrArrayObjectsNested<A> addNewJSONSchemaPropsOrArrayObjectLike(JSONSchemaPropsOrArray item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrArrayObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.JSONSchemaPropsOrArrayObjectsNested<A> setNewJSONSchemaPropsOrArrayObjectLike(Integer index,JSONSchemaPropsOrArray item) {
    return new ConversionRequestFluentImpl.JSONSchemaPropsOrArrayObjectsNestedImpl(index, item);
  }
  public A addToConversionReviewObjects(Integer index,ConversionReview item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionReviewBuilder builder = new ConversionReviewBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToConversionReviewObjects(Integer index,ConversionReview item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    ConversionReviewBuilder builder = new ConversionReviewBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToConversionReviewObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionReview... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionReview item : items) {ConversionReviewBuilder builder = new ConversionReviewBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToConversionReviewObjects(Collection<ConversionReview> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (ConversionReview item : items) {ConversionReviewBuilder builder = new ConversionReviewBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromConversionReviewObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionReview... items) {
    for (ConversionReview item : items) {ConversionReviewBuilder builder = new ConversionReviewBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromConversionReviewObjects(Collection<ConversionReview> items) {
    for (ConversionReview item : items) {ConversionReviewBuilder builder = new ConversionReviewBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConversionReviewObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.ConversionReviewObjectsNested<A> addNewConversionReviewObject() {
    return new ConversionRequestFluentImpl.ConversionReviewObjectsNestedImpl();
  }
  public ConversionRequestFluent.ConversionReviewObjectsNested<A> addNewConversionReviewObjectLike(ConversionReview item) {
    return new ConversionRequestFluentImpl.ConversionReviewObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.ConversionReviewObjectsNested<A> setNewConversionReviewObjectLike(Integer index,ConversionReview item) {
    return new ConversionRequestFluentImpl.ConversionReviewObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceValidationObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceValidationObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceValidationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceValidationObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceValidationObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceValidationObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceValidationObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceValidationObjectsNested<A> addNewV1beta1CustomResourceValidationObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceValidationObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceValidationObjectsNested<A> addNewCustomResourceValidationObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceValidationObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceValidationObjectsNested<A> setNewCustomResourceValidationObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceValidationObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceConversionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceConversionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceConversionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceConversionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceConversionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceConversionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceConversionObjectsNested<A> addNewV1beta1CustomResourceConversionObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceConversionObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceConversionObjectsNested<A> addNewCustomResourceConversionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceConversionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceConversionObjectsNested<A> setNewCustomResourceConversionObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceConversionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> addNewV1beta1CustomResourceDefinitionObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> setNewCustomResourceDefinitionObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl(index, item);
  }
  public A addToCustomResourceDefinitionSpecObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToCustomResourceDefinitionSpecObjects(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToCustomResourceDefinitionSpecObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToV1beta1CustomResourceDefinitionSpecObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromCustomResourceDefinitionSpecObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec... items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromV1beta1CustomResourceDefinitionSpecObjects(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec> items) {
    for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromV1beta1CustomResourceDefinitionSpecObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionSpecObjectsNested<A> addNewV1beta1CustomResourceDefinitionSpecObject() {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionSpecObjectsNestedImpl();
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionSpecObjectsNested<A> addNewCustomResourceDefinitionSpecObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionSpecObjectsNestedImpl(-1, item);
  }
  public ConversionRequestFluent.V1beta1CustomResourceDefinitionSpecObjectsNested<A> setNewCustomResourceDefinitionSpecObjectLike(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    return new ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionSpecObjectsNestedImpl(index, item);
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConversionRequestFluentImpl that = (ConversionRequestFluentImpl) o;
    if (desiredAPIVersion != null ? !desiredAPIVersion.equals(that.desiredAPIVersion) :that.desiredAPIVersion != null) return false;
    if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(desiredAPIVersion,  objects,  uid,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (desiredAPIVersion != null) { sb.append("desiredAPIVersion:"); sb.append(desiredAPIVersion + ","); }
    if (objects != null && !objects.isEmpty()) { sb.append("objects:"); sb.append(objects + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayFluentImpl<ConversionRequestFluent.V1beta1JSONSchemaPropsOrArrayObjectsNested<N>> implements ConversionRequestFluent.V1beta1JSONSchemaPropsOrArrayObjectsNested<N>,Nested<N>{
    V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(this, item);
    }
    V1beta1JSONSchemaPropsOrArrayObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1JSONSchemaPropsOrArrayObject() {
      return and();
    }
    
  }
  class LabelSelectorObjectsNestedImpl<N> extends LabelSelectorFluentImpl<ConversionRequestFluent.LabelSelectorObjectsNested<N>> implements ConversionRequestFluent.LabelSelectorObjectsNested<N>,Nested<N>{
    LabelSelectorObjectsNestedImpl(Integer index,LabelSelector item) {
      this.index = index;
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorObjectsNestedImpl() {
      this.index = -1;
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endLabelSelectorObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionStatusObjectsNestedImpl<N> extends CustomResourceDefinitionStatusFluentImpl<ConversionRequestFluent.CustomResourceDefinitionStatusObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionStatusObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionStatusObjectsNestedImpl(Integer index,CustomResourceDefinitionStatus item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionStatusBuilder(this, item);
    }
    CustomResourceDefinitionStatusObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionStatusBuilder(this);
    }
    CustomResourceDefinitionStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionStatusObject() {
      return and();
    }
    
  }
  class ServiceReferenceObjectsNestedImpl<N> extends ServiceReferenceFluentImpl<ConversionRequestFluent.ServiceReferenceObjectsNested<N>> implements ConversionRequestFluent.ServiceReferenceObjectsNested<N>,Nested<N>{
    ServiceReferenceObjectsNestedImpl(Integer index,ServiceReference item) {
      this.index = index;
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceReferenceBuilder(this);
    }
    ServiceReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endServiceReferenceObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionStatusObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionStatusObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionStatusObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionStatusObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionStatusObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionStatusObject() {
      return and();
    }
    
  }
  class JSONSchemaPropsOrBoolObjectsNestedImpl<N> extends JSONSchemaPropsOrBoolFluentImpl<ConversionRequestFluent.JSONSchemaPropsOrBoolObjectsNested<N>> implements ConversionRequestFluent.JSONSchemaPropsOrBoolObjectsNested<N>,Nested<N>{
    JSONSchemaPropsOrBoolObjectsNestedImpl(Integer index,JSONSchemaPropsOrBool item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    JSONSchemaPropsOrBoolObjectsNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsOrBoolBuilder(this);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endJSONSchemaPropsOrBoolObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionSpecObjectsNestedImpl<N> extends CustomResourceDefinitionSpecFluentImpl<ConversionRequestFluent.CustomResourceDefinitionSpecObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionSpecObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionSpecObjectsNestedImpl(Integer index,CustomResourceDefinitionSpec item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionSpecBuilder(this, item);
    }
    CustomResourceDefinitionSpecObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionSpecBuilder(this);
    }
    CustomResourceDefinitionSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionSpecObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceSubresourceStatusObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusFluentImpl<ConversionRequestFluent.V1beta1CustomResourceSubresourceStatusObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceSubresourceStatusObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceSubresourceStatusObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(this, item);
    }
    V1beta1CustomResourceSubresourceStatusObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceSubresourceStatusObject() {
      return and();
    }
    
  }
  class PodTemplateSpecObjectsNestedImpl<N> extends PodTemplateSpecFluentImpl<ConversionRequestFluent.PodTemplateSpecObjectsNested<N>> implements ConversionRequestFluent.PodTemplateSpecObjectsNested<N>,Nested<N>{
    PodTemplateSpecObjectsNestedImpl(Integer index,PodTemplateSpec item) {
      this.index = index;
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecObjectsNestedImpl() {
      this.index = -1;
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endPodTemplateSpecObject() {
      return and();
    }
    
  }
  class CustomResourceSubresourceScaleObjectsNestedImpl<N> extends CustomResourceSubresourceScaleFluentImpl<ConversionRequestFluent.CustomResourceSubresourceScaleObjectsNested<N>> implements ConversionRequestFluent.CustomResourceSubresourceScaleObjectsNested<N>,Nested<N>{
    CustomResourceSubresourceScaleObjectsNestedImpl(Integer index,CustomResourceSubresourceScale item) {
      this.index = index;
      this.builder = new CustomResourceSubresourceScaleBuilder(this, item);
    }
    CustomResourceSubresourceScaleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceSubresourceScaleBuilder(this);
    }
    CustomResourceSubresourceScaleBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceSubresourceScaleObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionNamesObjectsNestedImpl<N> extends CustomResourceDefinitionNamesFluentImpl<ConversionRequestFluent.CustomResourceDefinitionNamesObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionNamesObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionNamesObjectsNestedImpl(Integer index,CustomResourceDefinitionNames item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
    }
    CustomResourceDefinitionNamesObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionNamesBuilder(this);
    }
    CustomResourceDefinitionNamesBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionNamesObject() {
      return and();
    }
    
  }
  class V1beta1ExternalDocumentationObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationFluentImpl<ConversionRequestFluent.V1beta1ExternalDocumentationObjectsNested<N>> implements ConversionRequestFluent.V1beta1ExternalDocumentationObjectsNested<N>,Nested<N>{
    V1beta1ExternalDocumentationObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(this, item);
    }
    V1beta1ExternalDocumentationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1ExternalDocumentationObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceSubresourceScaleObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleFluentImpl<ConversionRequestFluent.V1beta1CustomResourceSubresourceScaleObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceSubresourceScaleObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceSubresourceScaleObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(this, item);
    }
    V1beta1CustomResourceSubresourceScaleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceSubresourceScaleObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionConditionObjectsNestedImpl<N> extends CustomResourceDefinitionConditionFluentImpl<ConversionRequestFluent.CustomResourceDefinitionConditionObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionConditionObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionConditionObjectsNestedImpl(Integer index,CustomResourceDefinitionCondition item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionConditionBuilder(this, item);
    }
    CustomResourceDefinitionConditionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionConditionBuilder(this);
    }
    CustomResourceDefinitionConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionConditionObject() {
      return and();
    }
    
  }
  class CustomResourceSubresourceStatusObjectsNestedImpl<N> extends CustomResourceSubresourceStatusFluentImpl<ConversionRequestFluent.CustomResourceSubresourceStatusObjectsNested<N>> implements ConversionRequestFluent.CustomResourceSubresourceStatusObjectsNested<N>,Nested<N>{
    CustomResourceSubresourceStatusObjectsNestedImpl(Integer index,CustomResourceSubresourceStatus item) {
      this.index = index;
      this.builder = new CustomResourceSubresourceStatusBuilder(this, item);
    }
    CustomResourceSubresourceStatusObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceSubresourceStatusBuilder(this);
    }
    CustomResourceSubresourceStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceSubresourceStatusObject() {
      return and();
    }
    
  }
  class ResourceRequirementsObjectsNestedImpl<N> extends ResourceRequirementsFluentImpl<ConversionRequestFluent.ResourceRequirementsObjectsNested<N>> implements ConversionRequestFluent.ResourceRequirementsObjectsNested<N>,Nested<N>{
    ResourceRequirementsObjectsNestedImpl(Integer index,ResourceRequirements item) {
      this.index = index;
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endResourceRequirementsObject() {
      return and();
    }
    
  }
  class CustomResourceValidationObjectsNestedImpl<N> extends CustomResourceValidationFluentImpl<ConversionRequestFluent.CustomResourceValidationObjectsNested<N>> implements ConversionRequestFluent.CustomResourceValidationObjectsNested<N>,Nested<N>{
    CustomResourceValidationObjectsNestedImpl(Integer index,CustomResourceValidation item) {
      this.index = index;
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    CustomResourceValidationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceValidationBuilder(this);
    }
    CustomResourceValidationBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceValidationObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionVersionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionVersionObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionVersionObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionVersionObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionVersionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionVersionObject() {
      return and();
    }
    
  }
  class V1beta1JSONSchemaPropsObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsFluentImpl<ConversionRequestFluent.V1beta1JSONSchemaPropsObjectsNested<N>> implements ConversionRequestFluent.V1beta1JSONSchemaPropsObjectsNested<N>,Nested<N>{
    V1beta1JSONSchemaPropsObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(this, item);
    }
    V1beta1JSONSchemaPropsObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1JSONSchemaPropsObject() {
      return and();
    }
    
  }
  class ConversionResponseObjectsNestedImpl<N> extends ConversionResponseFluentImpl<ConversionRequestFluent.ConversionResponseObjectsNested<N>> implements ConversionRequestFluent.ConversionResponseObjectsNested<N>,Nested<N>{
    ConversionResponseObjectsNestedImpl(Integer index,ConversionResponse item) {
      this.index = index;
      this.builder = new ConversionResponseBuilder(this, item);
    }
    ConversionResponseObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ConversionResponseBuilder(this);
    }
    ConversionResponseBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endConversionResponseObject() {
      return and();
    }
    
  }
  class V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolFluentImpl<ConversionRequestFluent.V1beta1JSONSchemaPropsOrBoolObjectsNested<N>> implements ConversionRequestFluent.V1beta1JSONSchemaPropsOrBoolObjectsNested<N>,Nested<N>{
    V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(this, item);
    }
    V1beta1JSONSchemaPropsOrBoolObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1JSONSchemaPropsOrBoolObject() {
      return and();
    }
    
  }
  class RawExtensionObjectsNestedImpl<N> extends RawExtensionFluentImpl<ConversionRequestFluent.RawExtensionObjectsNested<N>> implements ConversionRequestFluent.RawExtensionObjectsNested<N>,Nested<N>{
    RawExtensionObjectsNestedImpl(Integer index,RawExtension item) {
      this.index = index;
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRawExtensionObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionNamesObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionNamesObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionNamesObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionNamesObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionNamesObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionNamesObject() {
      return and();
    }
    
  }
  class V1beta1ValidationRuleObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleFluentImpl<ConversionRequestFluent.V1beta1ValidationRuleObjectsNested<N>> implements ConversionRequestFluent.V1beta1ValidationRuleObjectsNested<N>,Nested<N>{
    V1beta1ValidationRuleObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(this, item);
    }
    V1beta1ValidationRuleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1ValidationRuleObject() {
      return and();
    }
    
  }
  class JSONSchemaPropsOrStringArrayObjectsNestedImpl<N> extends JSONSchemaPropsOrStringArrayFluentImpl<ConversionRequestFluent.JSONSchemaPropsOrStringArrayObjectsNested<N>> implements ConversionRequestFluent.JSONSchemaPropsOrStringArrayObjectsNested<N>,Nested<N>{
    JSONSchemaPropsOrStringArrayObjectsNestedImpl(Integer index,JSONSchemaPropsOrStringArray item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrStringArrayBuilder(this, item);
    }
    JSONSchemaPropsOrStringArrayObjectsNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsOrStringArrayBuilder(this);
    }
    JSONSchemaPropsOrStringArrayBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endJSONSchemaPropsOrStringArrayObject() {
      return and();
    }
    
  }
  class ObjectMetaObjectsNestedImpl<N> extends ObjectMetaFluentImpl<ConversionRequestFluent.ObjectMetaObjectsNested<N>> implements ConversionRequestFluent.ObjectMetaObjectsNested<N>,Nested<N>{
    ObjectMetaObjectsNestedImpl(Integer index,ObjectMeta item) {
      this.index = index;
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endObjectMetaObject() {
      return and();
    }
    
  }
  class CustomResourceSubresourcesObjectsNestedImpl<N> extends CustomResourceSubresourcesFluentImpl<ConversionRequestFluent.CustomResourceSubresourcesObjectsNested<N>> implements ConversionRequestFluent.CustomResourceSubresourcesObjectsNested<N>,Nested<N>{
    CustomResourceSubresourcesObjectsNestedImpl(Integer index,CustomResourceSubresources item) {
      this.index = index;
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    CustomResourceSubresourcesObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceSubresourcesBuilder(this);
    }
    CustomResourceSubresourcesBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceSubresourcesObject() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObjectsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ConversionRequestFluent.PersistentVolumeClaimObjectsNested<N>> implements ConversionRequestFluent.PersistentVolumeClaimObjectsNested<N>,Nested<N>{
    PersistentVolumeClaimObjectsNestedImpl(Integer index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObjectsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endPersistentVolumeClaimObject() {
      return and();
    }
    
  }
  class ConversionRequestObjectsNestedImpl<N> extends ConversionRequestFluentImpl<ConversionRequestFluent.ConversionRequestObjectsNested<N>> implements ConversionRequestFluent.ConversionRequestObjectsNested<N>,Nested<N>{
    ConversionRequestObjectsNestedImpl(Integer index,ConversionRequest item) {
      this.index = index;
      this.builder = new ConversionRequestBuilder(this, item);
    }
    ConversionRequestObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ConversionRequestBuilder(this);
    }
    ConversionRequestBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endConversionRequestObject() {
      return and();
    }
    
  }
  class JSONSchemaPropsObjectsNestedImpl<N> extends JSONSchemaPropsFluentImpl<ConversionRequestFluent.JSONSchemaPropsObjectsNested<N>> implements ConversionRequestFluent.JSONSchemaPropsObjectsNested<N>,Nested<N>{
    JSONSchemaPropsObjectsNestedImpl(Integer index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsObjectsNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endJSONSchemaPropsObject() {
      return and();
    }
    
  }
  class V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayFluentImpl<ConversionRequestFluent.V1beta1JSONSchemaPropsOrStringArrayObjectsNested<N>> implements ConversionRequestFluent.V1beta1JSONSchemaPropsOrStringArrayObjectsNested<N>,Nested<N>{
    V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(this, item);
    }
    V1beta1JSONSchemaPropsOrStringArrayObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1JSONSchemaPropsOrStringArrayObject() {
      return and();
    }
    
  }
  class WebhookClientConfigObjectsNestedImpl<N> extends WebhookClientConfigFluentImpl<ConversionRequestFluent.WebhookClientConfigObjectsNested<N>> implements ConversionRequestFluent.WebhookClientConfigObjectsNested<N>,Nested<N>{
    WebhookClientConfigObjectsNestedImpl(Integer index,WebhookClientConfig item) {
      this.index = index;
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    WebhookClientConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new WebhookClientConfigBuilder(this);
    }
    WebhookClientConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endWebhookClientConfigObject() {
      return and();
    }
    
  }
  class ContainerObjectsNestedImpl<N> extends ContainerFluentImpl<ConversionRequestFluent.ContainerObjectsNested<N>> implements ConversionRequestFluent.ContainerObjectsNested<N>,Nested<N>{
    ContainerObjectsNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endContainerObject() {
      return and();
    }
    
  }
  class GenericKubernetesResourceObjectsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<ConversionRequestFluent.GenericKubernetesResourceObjectsNested<N>> implements ConversionRequestFluent.GenericKubernetesResourceObjectsNested<N>,Nested<N>{
    GenericKubernetesResourceObjectsNestedImpl(Integer index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endGenericKubernetesResourceObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceColumnDefinitionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluentImpl<ConversionRequestFluent.V1beta1CustomResourceColumnDefinitionObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceColumnDefinitionObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceColumnDefinitionObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this, item);
    }
    V1beta1CustomResourceColumnDefinitionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceColumnDefinitionObject() {
      return and();
    }
    
  }
  class V1beta1WebhookClientConfigObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigFluentImpl<ConversionRequestFluent.V1beta1WebhookClientConfigObjectsNested<N>> implements ConversionRequestFluent.V1beta1WebhookClientConfigObjectsNested<N>,Nested<N>{
    V1beta1WebhookClientConfigObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(this, item);
    }
    V1beta1WebhookClientConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1WebhookClientConfigObject() {
      return and();
    }
    
  }
  class CustomResourceColumnDefinitionObjectsNestedImpl<N> extends CustomResourceColumnDefinitionFluentImpl<ConversionRequestFluent.CustomResourceColumnDefinitionObjectsNested<N>> implements ConversionRequestFluent.CustomResourceColumnDefinitionObjectsNested<N>,Nested<N>{
    CustomResourceColumnDefinitionObjectsNestedImpl(Integer index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    CustomResourceColumnDefinitionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceColumnDefinitionBuilder(this);
    }
    CustomResourceColumnDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceColumnDefinitionObject() {
      return and();
    }
    
  }
  class WebhookConversionObjectsNestedImpl<N> extends WebhookConversionFluentImpl<ConversionRequestFluent.WebhookConversionObjectsNested<N>> implements ConversionRequestFluent.WebhookConversionObjectsNested<N>,Nested<N>{
    WebhookConversionObjectsNestedImpl(Integer index,WebhookConversion item) {
      this.index = index;
      this.builder = new WebhookConversionBuilder(this, item);
    }
    WebhookConversionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new WebhookConversionBuilder(this);
    }
    WebhookConversionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endWebhookConversionObject() {
      return and();
    }
    
  }
  class LocalObjectReferenceObjectsNestedImpl<N> extends LocalObjectReferenceFluentImpl<ConversionRequestFluent.LocalObjectReferenceObjectsNested<N>> implements ConversionRequestFluent.LocalObjectReferenceObjectsNested<N>,Nested<N>{
    LocalObjectReferenceObjectsNestedImpl(Integer index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endLocalObjectReferenceObject() {
      return and();
    }
    
  }
  class ExternalDocumentationObjectsNestedImpl<N> extends ExternalDocumentationFluentImpl<ConversionRequestFluent.ExternalDocumentationObjectsNested<N>> implements ConversionRequestFluent.ExternalDocumentationObjectsNested<N>,Nested<N>{
    ExternalDocumentationObjectsNestedImpl(Integer index,ExternalDocumentation item) {
      this.index = index;
      this.builder = new ExternalDocumentationBuilder(this, item);
    }
    ExternalDocumentationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ExternalDocumentationBuilder(this);
    }
    ExternalDocumentationBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endExternalDocumentationObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceSubresourcesObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesFluentImpl<ConversionRequestFluent.V1beta1CustomResourceSubresourcesObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceSubresourcesObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceSubresourcesObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this, item);
    }
    V1beta1CustomResourceSubresourcesObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceSubresourcesObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionVersionObjectsNestedImpl<N> extends CustomResourceDefinitionVersionFluentImpl<ConversionRequestFluent.CustomResourceDefinitionVersionObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionVersionObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionVersionObjectsNestedImpl(Integer index,CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
    }
    CustomResourceDefinitionVersionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionVersionBuilder(this);
    }
    CustomResourceDefinitionVersionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionVersionObject() {
      return and();
    }
    
  }
  class CustomResourceConversionObjectsNestedImpl<N> extends CustomResourceConversionFluentImpl<ConversionRequestFluent.CustomResourceConversionObjectsNested<N>> implements ConversionRequestFluent.CustomResourceConversionObjectsNested<N>,Nested<N>{
    CustomResourceConversionObjectsNestedImpl(Integer index,CustomResourceConversion item) {
      this.index = index;
      this.builder = new CustomResourceConversionBuilder(this, item);
    }
    CustomResourceConversionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceConversionBuilder(this);
    }
    CustomResourceConversionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceConversionObject() {
      return and();
    }
    
  }
  class ValidationRuleObjectsNestedImpl<N> extends ValidationRuleFluentImpl<ConversionRequestFluent.ValidationRuleObjectsNested<N>> implements ConversionRequestFluent.ValidationRuleObjectsNested<N>,Nested<N>{
    ValidationRuleObjectsNestedImpl(Integer index,ValidationRule item) {
      this.index = index;
      this.builder = new ValidationRuleBuilder(this, item);
    }
    ValidationRuleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ValidationRuleBuilder(this);
    }
    ValidationRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endValidationRuleObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionObjectsNestedImpl<N> extends CustomResourceDefinitionFluentImpl<ConversionRequestFluent.CustomResourceDefinitionObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionObjectsNestedImpl(Integer index,CustomResourceDefinition item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionBuilder(this, item);
    }
    CustomResourceDefinitionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionBuilder(this);
    }
    CustomResourceDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionConditionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionConditionObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionConditionObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionConditionObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionConditionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionConditionObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionListObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionListObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionListObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionListObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionListObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionListObject() {
      return and();
    }
    
  }
  class V1beta1ServiceReferenceObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceFluentImpl<ConversionRequestFluent.V1beta1ServiceReferenceObjectsNested<N>> implements ConversionRequestFluent.V1beta1ServiceReferenceObjectsNested<N>,Nested<N>{
    V1beta1ServiceReferenceObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(this, item);
    }
    V1beta1ServiceReferenceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1ServiceReferenceObject() {
      return and();
    }
    
  }
  class CustomResourceDefinitionListObjectsNestedImpl<N> extends CustomResourceDefinitionListFluentImpl<ConversionRequestFluent.CustomResourceDefinitionListObjectsNested<N>> implements ConversionRequestFluent.CustomResourceDefinitionListObjectsNested<N>,Nested<N>{
    CustomResourceDefinitionListObjectsNestedImpl(Integer index,CustomResourceDefinitionList item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionListBuilder(this, item);
    }
    CustomResourceDefinitionListObjectsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionListBuilder(this);
    }
    CustomResourceDefinitionListBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endCustomResourceDefinitionListObject() {
      return and();
    }
    
  }
  class ObjectReferenceObjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ConversionRequestFluent.ObjectReferenceObjectsNested<N>> implements ConversionRequestFluent.ObjectReferenceObjectsNested<N>,Nested<N>{
    ObjectReferenceObjectsNestedImpl(Integer index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endObjectReferenceObject() {
      return and();
    }
    
  }
  class JSONSchemaPropsOrArrayObjectsNestedImpl<N> extends JSONSchemaPropsOrArrayFluentImpl<ConversionRequestFluent.JSONSchemaPropsOrArrayObjectsNested<N>> implements ConversionRequestFluent.JSONSchemaPropsOrArrayObjectsNested<N>,Nested<N>{
    JSONSchemaPropsOrArrayObjectsNestedImpl(Integer index,JSONSchemaPropsOrArray item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrArrayBuilder(this, item);
    }
    JSONSchemaPropsOrArrayObjectsNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsOrArrayBuilder(this);
    }
    JSONSchemaPropsOrArrayBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endJSONSchemaPropsOrArrayObject() {
      return and();
    }
    
  }
  class ConversionReviewObjectsNestedImpl<N> extends ConversionReviewFluentImpl<ConversionRequestFluent.ConversionReviewObjectsNested<N>> implements ConversionRequestFluent.ConversionReviewObjectsNested<N>,Nested<N>{
    ConversionReviewObjectsNestedImpl(Integer index,ConversionReview item) {
      this.index = index;
      this.builder = new ConversionReviewBuilder(this, item);
    }
    ConversionReviewObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ConversionReviewBuilder(this);
    }
    ConversionReviewBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endConversionReviewObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceValidationObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluentImpl<ConversionRequestFluent.V1beta1CustomResourceValidationObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceValidationObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceValidationObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this, item);
    }
    V1beta1CustomResourceValidationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceValidationObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceConversionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluentImpl<ConversionRequestFluent.V1beta1CustomResourceConversionObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceConversionObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceConversionObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(this, item);
    }
    V1beta1CustomResourceConversionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceConversionObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionObject() {
      return and();
    }
    
  }
  class V1beta1CustomResourceDefinitionSpecObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluentImpl<ConversionRequestFluent.V1beta1CustomResourceDefinitionSpecObjectsNested<N>> implements ConversionRequestFluent.V1beta1CustomResourceDefinitionSpecObjectsNested<N>,Nested<N>{
    V1beta1CustomResourceDefinitionSpecObjectsNestedImpl(Integer index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(this, item);
    }
    V1beta1CustomResourceDefinitionSpecObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endV1beta1CustomResourceDefinitionSpecObject() {
      return and();
    }
    
  }
  
}