package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JSONSchemaPropsOrStringArrayFluentImpl<A extends JSONSchemaPropsOrStringArrayFluent<A>> extends BaseFluent<A> implements JSONSchemaPropsOrStringArrayFluent<A>{
  public JSONSchemaPropsOrStringArrayFluentImpl() {
  }
  public JSONSchemaPropsOrStringArrayFluentImpl(JSONSchemaPropsOrStringArray instance) {
    this.withProperty(instance.getProperty()); 
    this.withSchema(instance.getSchema()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> property = new ArrayList<String>();
  private JSONSchemaPropsBuilder schema;
  private Map<String,Object> additionalProperties;
  public A addToProperty(Integer index,String item) {
    if (this.property == null) {this.property = new ArrayList<String>();}
    this.property.add(index, item);
    return (A)this;
  }
  public A setToProperty(Integer index,String item) {
    if (this.property == null) {this.property = new ArrayList<String>();}
    this.property.set(index, item); return (A)this;
  }
  public A addToProperty(java.lang.String... items) {
    if (this.property == null) {this.property = new ArrayList<String>();}
    for (String item : items) {this.property.add(item);} return (A)this;
  }
  public A addAllToProperty(Collection<String> items) {
    if (this.property == null) {this.property = new ArrayList<String>();}
    for (String item : items) {this.property.add(item);} return (A)this;
  }
  public A removeFromProperty(java.lang.String... items) {
    for (String item : items) {if (this.property!= null){ this.property.remove(item);}} return (A)this;
  }
  public A removeAllFromProperty(Collection<String> items) {
    for (String item : items) {if (this.property!= null){ this.property.remove(item);}} return (A)this;
  }
  public List<String> getProperty() {
    return this.property;
  }
  public String getProperty(Integer index) {
    return this.property.get(index);
  }
  public String getFirstProperty() {
    return this.property.get(0);
  }
  public String getLastProperty() {
    return this.property.get(property.size() - 1);
  }
  public String getMatchingProperty(Predicate<String> predicate) {
    for (String item: property) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingProperty(Predicate<String> predicate) {
    for (String item: property) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withProperty(List<String> property) {
    if (property != null) {this.property = new ArrayList(); for (String item : property){this.addToProperty(item);}} else { this.property = null;} return (A) this;
  }
  public A withProperty(java.lang.String... property) {
    if (this.property != null) {this.property.clear();}
    if (property != null) {for (String item :property){ this.addToProperty(item);}} return (A) this;
  }
  public Boolean hasProperty() {
    return property != null && !property.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSchema instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaProps getSchema() {
    return this.schema!=null ?this.schema.build():null;
  }
  public JSONSchemaProps buildSchema() {
    return this.schema!=null ?this.schema.build():null;
  }
  public A withSchema(JSONSchemaProps schema) {
    _visitables.get("schema").remove(this.schema);
    if (schema!=null){ this.schema= new JSONSchemaPropsBuilder(schema); _visitables.get("schema").add(this.schema);} else { this.schema = null; _visitables.get("schema").remove(this.schema); } return (A) this;
  }
  public Boolean hasSchema() {
    return this.schema != null;
  }
  public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> withNewSchema() {
    return new JSONSchemaPropsOrStringArrayFluentImpl.SchemaNestedImpl();
  }
  public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
    return new JSONSchemaPropsOrStringArrayFluentImpl.SchemaNestedImpl(item);
  }
  public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editSchema() {
    return withNewSchemaLike(getSchema());
  }
  public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editOrNewSchema() {
    return withNewSchemaLike(getSchema() != null ? getSchema(): new JSONSchemaPropsBuilder().build());
  }
  public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
    return withNewSchemaLike(getSchema() != null ? getSchema(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JSONSchemaPropsOrStringArrayFluentImpl that = (JSONSchemaPropsOrStringArrayFluentImpl) o;
    if (property != null ? !property.equals(that.property) :that.property != null) return false;
    if (schema != null ? !schema.equals(that.schema) :that.schema != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(property,  schema,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (property != null && !property.isEmpty()) { sb.append("property:"); sb.append(property + ","); }
    if (schema != null) { sb.append("schema:"); sb.append(schema + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SchemaNestedImpl<N> extends JSONSchemaPropsFluentImpl<JSONSchemaPropsOrStringArrayFluent.SchemaNested<N>> implements JSONSchemaPropsOrStringArrayFluent.SchemaNested<N>,Nested<N>{
    SchemaNestedImpl(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    SchemaNestedImpl() {
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsOrStringArrayFluentImpl.this.withSchema(builder.build());
    }
    public N endSchema() {
      return and();
    }
    
  }
  
}